/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.common.Handlers;
import com.enderio.core.common.enchant.EnchantXPBoost;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.Scheduler;
import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Handlers.Handler
public class XPBoostHandler {
    private static final Method getExperiencePoints = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"getExperiencePoints", (String)"func_70693_a", (Class[])new Class[]{EntityPlayer.class});
    @Nonnull
    private static final String NBT_KEY = "endercore:xpboost";

    @SubscribeEvent
    public static void handleEntityKill(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Entity killer = event.getSource().func_76346_g();
        if (!entity.field_70170_p.field_72995_K && killer != null) {
            NBTTagCompound tag;
            if (killer instanceof EntityPlayer) {
                XPBoostHandler.scheduleXP((Entity)entity, XPBoostHandler.getXPBoost(entity, (EntityPlayer)killer));
            } else if (killer instanceof EntityArrow && (tag = killer.getEntityData()).func_74764_b(NBT_KEY) && tag.func_74762_e(NBT_KEY) >= 0) {
                int level = tag.func_74762_e(NBT_KEY);
                EntityArrow arrow = (EntityArrow)killer;
                XPBoostHandler.scheduleXP((Entity)entity, XPBoostHandler.getXPBoost(entity, (EntityPlayer)arrow.field_70250_c, level));
            }
        }
    }

    @SubscribeEvent
    public static void handleArrowFire(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            arrow.getEntityData().func_74768_a(NBT_KEY, XPBoostHandler.getXPBoostLevel(arrow.field_70250_c));
        }
    }

    @SubscribeEvent
    public static void handleBlockBreak(BlockEvent.BreakEvent event) {
        int level = XPBoostHandler.getXPBoostLevel((Entity)event.getPlayer());
        if (level >= 0) {
            IBlockState state = NullHelper.notnullF(event.getState(), "BreakEvent.getState()");
            World world = NullHelper.notnullF(event.getWorld(), "BreakEvent.getWorld()");
            BlockPos pos = NullHelper.notnullF(event.getPos(), "BreakEvent.getPos()");
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)event.getPlayer().func_184614_ca());
            int xp = state.func_177230_c().getExpDrop(state, (IBlockAccess)world, pos, fortune);
            if (xp > 0) {
                world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, XPBoostHandler.getXPBoost(xp, level)));
            }
        }
    }

    private static int getXPBoost(EntityLivingBase killed, EntityPlayer player) {
        return XPBoostHandler.getXPBoost(killed, player, XPBoostHandler.getXPBoostLevel((Entity)player));
    }

    private static int getXPBoost(EntityLivingBase killed, EntityPlayer player, int level) {
        if (level >= 0) {
            try {
                int xp = (Integer)getExperiencePoints.invoke((Object)killed, player);
                return XPBoostHandler.getXPBoost(xp, level);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return 0;
    }

    private static int getXPBoost(int xp, int level) {
        return Math.round((float)xp * ((float)Math.log10(level + 1) * 2.0f));
    }

    private static int getXPBoostLevel(Entity player) {
        if (player == null || !(player instanceof EntityPlayer) || player instanceof FakePlayer) {
            return -1;
        }
        ItemStack weapon = ((EntityLivingBase)player).func_184614_ca();
        if (weapon.func_190926_b()) {
            return -1;
        }
        int result = -1;
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)weapon);
        for (Enchantment i : enchants.keySet()) {
            if (i == EnchantXPBoost.instance()) {
                result = (Integer)enchants.get(i);
                continue;
            }
            if (i != Enchantments.field_185306_r) continue;
            return -1;
        }
        return result;
    }

    private static void scheduleXP(Entity entity, int boost) {
        XPBoostHandler.scheduleXP(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, boost);
    }

    private static void scheduleXP(final World world, final double x, final double y, final double z, final int boost) {
        if (boost <= 0) {
            return;
        }
        Scheduler.instance().schedule(20, new Runnable(){

            @Override
            public void run() {
                world.func_72838_d((Entity)new EntityXPOrb(world, x, y, z, boost));
            }
        });
    }

    private XPBoostHandler() {
    }
}

