/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.fluid;

import com.enderio.core.common.util.NullHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidEnder
extends BlockFluidClassic {
    private float fogColorRed = 1.0f;
    private float fogColorGreen = 1.0f;
    private float fogColorBlue = 1.0f;
    @Nonnull
    private final Material material;

    protected BlockFluidEnder(@Nonnull Fluid fluid, @Nonnull Material material, int fogColor) {
        super(fluid, (Material)new MaterialLiquid(material.func_151565_r()){

            public boolean func_76230_c() {
                return true;
            }
        });
        this.material = material;
        float dim = 1.0f;
        while (this.getFogColorRed() > 0.2f || this.getFogColorGreen() > 0.2f || this.getFogColorBlue() > 0.2f) {
            this.setFogColorRed((float)(fogColor >> 16 & 0xFF) / 255.0f * dim);
            this.setFogColorGreen((float)(fogColor >> 8 & 0xFF) / 255.0f * dim);
            this.setFogColorBlue((float)(fogColor & 0xFF) / 255.0f * dim);
            dim *= 0.9f;
        }
        this.setNames(fluid);
    }

    protected void setNames(Fluid fluid) {
        this.func_149663_c(NullHelper.notnullF(fluid.getUnlocalizedName(), "encountered fluid without a name"));
        this.setRegistryName("block_fluid_" + fluid.getName().toLowerCase(Locale.ENGLISH));
    }

    public float getFogColorRed() {
        return this.fogColorRed;
    }

    public void setFogColorRed(float fogColorRed) {
        this.fogColorRed = fogColorRed;
    }

    public float getFogColorGreen() {
        return this.fogColorGreen;
    }

    public void setFogColorGreen(float fogColorGreen) {
        this.fogColorGreen = fogColorGreen;
    }

    public float getFogColorBlue() {
        return this.fogColorBlue;
    }

    public void setFogColorBlue(float fogColorBlue) {
        this.fogColorBlue = fogColorBlue;
    }

    public Boolean isEntityInsideMaterial(@Nonnull IBlockAccess world, @Nonnull BlockPos blockpos, @Nonnull IBlockState iblockstate, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
        if (materialIn == this.material || materialIn == this.field_149764_J) {
            return Boolean.TRUE;
        }
        return super.isEntityInsideMaterial(world, blockpos, iblockstate, entity, yToTest, materialIn, testingHead);
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState bs = NullHelper.notnullF(world, "canDisplace() called without world").func_180495_p(NullHelper.notnullF(pos, "canDisplace() called without pos"));
        if (bs.func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        IBlockState bs = NullHelper.notnullF(world, "displaceIfPossible() called without world").func_180495_p(NullHelper.notnullF(pos, "displaceIfPossible() called without pos"));
        if (bs.func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(tab, list);
        }
    }
}

