/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.block.BlockStairsBase;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.block.EnumBlockSlab;
import slimeknights.mantle.client.CreativeTab;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.item.ItemBlockSlab;
import slimeknights.mantle.item.ItemMetaDynamic;
import slimeknights.tmechworks.TMechworks;
import slimeknights.tmechworks.blocks.Drawbridge;
import slimeknights.tmechworks.blocks.Firestarter;
import slimeknights.tmechworks.blocks.IEnumBlock;
import slimeknights.tmechworks.blocks.Metal;
import slimeknights.tmechworks.blocks.logic.FirestarterLogic;
import slimeknights.tmechworks.blocks.logic.drawbridge.AdvancedDrawbridgeLogic;
import slimeknights.tmechworks.blocks.logic.drawbridge.DrawbridgeLogic;
import slimeknights.tmechworks.blocks.logic.drawbridge.ExtendedDrawbridgeLogic;
import slimeknights.tmechworks.items.ItemBlockMetaExtra;
import slimeknights.tmechworks.library.Util;

public class MechworksContent {
    public static ItemMetaDynamic ingots;
    public static ItemMetaDynamic nuggets;
    public static Metal metals;
    public static Drawbridge drawbridge;
    public static Firestarter firestarter;
    public static CreativeTab tabMechworks;
    public static ItemStack ingotAluminum;
    public static ItemStack ingotTin;
    public static ItemStack ingotCopper;
    public static ItemStack ingotBronze;
    public static ItemStack nuggetAluminum;
    public static ItemStack nuggetCopper;
    public static ItemStack nuggetTin;
    public static ItemStack nuggetBronze;
    public static ItemStack blockAluminum;
    public static ItemStack blockCopper;
    public static ItemStack blockTin;
    public static ItemStack blockBronze;

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        metals = MechworksContent.registerEnumItemBlock((IForgeRegistry<Item>)registry, metals);
        blockAluminum = new ItemStack((Block)metals, 1, Metal.MetalTypes.ALUMINUM.getMeta());
        blockCopper = new ItemStack((Block)metals, 1, Metal.MetalTypes.COPPER.getMeta());
        blockTin = new ItemStack((Block)metals, 1, Metal.MetalTypes.TIN.getMeta());
        blockTin = new ItemStack((Block)metals, 1, Metal.MetalTypes.BRONZE.getMeta());
        drawbridge = MechworksContent.registerEnumItemBlockExtra((IForgeRegistry<Item>)registry, drawbridge, new String[0]);
        firestarter = MechworksContent.registerEnumItemBlockExtra((IForgeRegistry<Item>)registry, firestarter, "extinguish=true", "facing=inv");
        ingots = MechworksContent.registerItem((IForgeRegistry<Item>)registry, new ItemMetaDynamic(), "ingots");
        ingots.func_77637_a((CreativeTabs)tabMechworks);
        nuggets = MechworksContent.registerItem((IForgeRegistry<Item>)registry, new ItemMetaDynamic(), "nuggets");
        nuggets.func_77637_a((CreativeTabs)tabMechworks);
        ingotAluminum = ingots.addMeta(0, "aluminum");
        nuggetAluminum = nuggets.addMeta(0, "aluminum");
        ingotCopper = ingots.addMeta(1, "copper");
        nuggetCopper = nuggets.addMeta(1, "copper");
        ingotTin = ingots.addMeta(2, "tin");
        nuggetTin = nuggets.addMeta(2, "tin");
        ingotBronze = ingots.addMeta(3, "bronze");
        nuggetBronze = nuggets.addMeta(3, "bronze");
        this.setupCreativeTabs();
        OreDictionary.registerOre((String)"ingotBronze", (ItemStack)ingotBronze);
        OreDictionary.registerOre((String)"ingotTin", (ItemStack)ingotTin);
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)ingotCopper);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        metals = MechworksContent.registerBlock((IForgeRegistry<Block>)registry, new Metal(), "metal");
        drawbridge = MechworksContent.registerBlock((IForgeRegistry<Block>)registry, new Drawbridge(), "drawbridge");
        drawbridge.func_149647_a((CreativeTabs)tabMechworks);
        MechworksContent.registerTE(DrawbridgeLogic.class, "drawbridge");
        MechworksContent.registerTE(ExtendedDrawbridgeLogic.class, "drawbridge.extended");
        MechworksContent.registerTE(AdvancedDrawbridgeLogic.class, "drawbridge.advanced");
        firestarter = MechworksContent.registerBlock((IForgeRegistry<Block>)registry, new Firestarter(), "firestarter");
        firestarter.func_149647_a((CreativeTabs)tabMechworks);
        MechworksContent.registerTE(FirestarterLogic.class, "firestarter");
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        TMechworks.proxy.registerModels();
    }

    private void setupCreativeTabs() {
        tabMechworks.setDisplayIcon(new ItemStack((Block)drawbridge, 1, 0));
    }

    protected static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        MechworksContent.register(registry, block, name);
        return block;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockStairsBase registerBlockStairsFrom(IForgeRegistry<Block> registry, EnumBlock<E> block, E value, String name) {
        return MechworksContent.registerBlock(registry, new BlockStairsBase(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    protected static <T extends Block> T registerItemBlock(IForgeRegistry<Item> registry, T block) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        itemBlock.func_77655_b(block.func_149739_a());
        MechworksContent.register(registry, itemBlock, block.getRegistryName());
        return block;
    }

    protected static <T extends EnumBlock<?>> T registerEnumItemBlock(IForgeRegistry<Item> registry, T block) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        itemBlock.func_77655_b(block.func_149739_a());
        MechworksContent.register(registry, itemBlock, block.getRegistryName());
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends EnumBlock<?>> T registerEnumItemBlockExtra(IForgeRegistry<Item> registry, T block, String ... extra) {
        MechworksContent.registerItemBlock(registry, (ItemBlock)new ItemBlockMetaExtra((Block)block, extra));
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends IEnumBlock<?>> T registerEnumItemBlockExtra(IForgeRegistry<Item> registry, T block, String ... extra) {
        MechworksContent.registerItemBlock(registry, (ItemBlock)new ItemBlockMetaExtra(block.getSelf(), extra));
        ItemBlockMeta.setMappingProperty((Block)block.getSelf(), block.getProperty());
        return block;
    }

    protected static <T extends Block> T registerItemBlock(IForgeRegistry<Item> registry, ItemBlock itemBlock) {
        itemBlock.func_77655_b(itemBlock.func_179223_d().func_149739_a());
        MechworksContent.register(registry, itemBlock, itemBlock.func_179223_d().getRegistryName());
        return (T)itemBlock.func_179223_d();
    }

    protected static <T extends Block> T registerItemBlockProp(IForgeRegistry<Item> registry, ItemBlock itemBlock, IProperty<?> property) {
        itemBlock.func_77655_b(itemBlock.func_179223_d().func_149739_a());
        MechworksContent.register(registry, itemBlock, itemBlock.func_179223_d().getRegistryName());
        ItemBlockMeta.setMappingProperty((Block)itemBlock.func_179223_d(), property);
        return (T)itemBlock.func_179223_d();
    }

    protected static <T extends EnumBlockSlab<?>> T registerEnumItemBlockSlab(IForgeRegistry<Item> registry, T block) {
        ItemBlockSlab itemBlock = new ItemBlockSlab(block);
        itemBlock.func_77655_b(block.func_149739_a());
        MechworksContent.register(registry, itemBlock, block.getRegistryName());
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends Item> T registerItem(IForgeRegistry<Item> registry, T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        item.func_77655_b(Util.prefix(name));
        item.setRegistryName(Util.getResource(name));
        registry.register(item);
        return item;
    }

    protected static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T thing, String name) {
        thing.setRegistryName(Util.getResource(name));
        registry.register(thing);
        return thing;
    }

    protected static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T thing, ResourceLocation name) {
        thing.setRegistryName(name);
        registry.register(thing);
        return thing;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! TE: %s", name));
        }
        GameRegistry.registerTileEntity(teClazz, (ResourceLocation)new ResourceLocation(Util.prefix(name)));
    }

    static {
        tabMechworks = new CreativeTab("TabMechworks", new ItemStack((Block)drawbridge));
    }
}

