/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.blocks.logic;

import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tmechworks.blocks.logic.IDisguisable;
import slimeknights.tmechworks.integration.IInformationProvider;

public abstract class RedstoneMachineLogicBase
extends TileInventory
implements IDisguisable,
ITickable,
IInformationProvider {
    private InventoryBasic disguiseInventory;
    private int redstoneState;
    private boolean isFirstTick = true;
    private EnumFacing facingDirection = EnumFacing.NORTH;

    public RedstoneMachineLogicBase(String name, int inventorySize) {
        this(name, inventorySize, 64);
    }

    public RedstoneMachineLogicBase(String name, int inventorySize, int maxStackSize) {
        super(name, inventorySize, maxStackSize);
        this.disguiseInventory = new InventoryBasic(name + ".disguise", false, 1);
    }

    public void updateRedstone() {
        if (this.isFirstTick) {
            return;
        }
        int oldPow = this.redstoneState;
        int sidePow = 0;
        for (EnumFacing face : EnumFacing.values()) {
            int pow = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(face), face);
            if (face == this.getFacingDirection() || pow <= 0 || pow <= sidePow) continue;
            sidePow = pow;
        }
        int pow = this.field_145850_b.func_175651_c(this.field_174879_c, EnumFacing.DOWN);
        if (pow > sidePow) {
            sidePow = pow;
        }
        this.redstoneState = sidePow;
        if (pow != oldPow) {
            this.onRedstoneUpdate();
        }
        this.onBlockUpdate();
        if (oldPow != this.redstoneState) {
            this.sync();
        }
    }

    public void onRedstoneUpdate() {
    }

    public void onBlockUpdate() {
    }

    public int getRedstoneState() {
        return this.redstoneState;
    }

    public EnumFacing getFacingDirection() {
        return this.facingDirection;
    }

    public void setFacingDirection(EnumFacing direction) {
        this.facingDirection = direction;
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.isFirstTick) {
            this.isFirstTick = false;
            this.updateRedstone();
            this.loadData();
            this.sync();
        }
    }

    public void loadData() {
    }

    @Override
    public ItemStack getDisguiseBlock() {
        return this.disguiseInventory.func_70301_a(0);
    }

    @Override
    public void setDisguiseBlock(ItemStack disguise) {
        this.disguiseInventory.func_70299_a(0, disguise);
    }

    @Override
    public void markDirtyD() {
        this.func_70296_d();
    }

    @Override
    public boolean canEditDisguise() {
        return true;
    }

    public NBTTagCompound writeItemData(NBTTagCompound tags) {
        ItemStack disguise;
        tags.func_74768_a("InventorySize", this.func_70302_i_());
        this.writeInventoryToNBT(tags);
        if (this.func_145818_k_()) {
            tags.func_74778_a("CustomName", this.inventoryTitle);
        }
        if (!(disguise = this.getDisguiseBlock()).func_190926_b()) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            itemNBT = disguise.func_77955_b(itemNBT);
            tags.func_74782_a("Disguise", (NBTBase)itemNBT);
        }
        return tags;
    }

    public void readItemData(NBTTagCompound tags) {
        if (tags.func_74764_b("Disguise")) {
            NBTTagCompound itemNBT = tags.func_74775_l("Disguise");
            ItemStack disguise = new ItemStack(itemNBT);
            this.setDisguiseBlock(disguise);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        tags = this.writeItemData(tags);
        tags.func_74768_a("Redstone", this.redstoneState);
        tags.func_74768_a("Facing", this.facingDirection.ordinal());
        return tags;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readItemData(tags);
        this.redstoneState = tags.func_74762_e("Redstone");
        this.facingDirection = EnumFacing.values()[tags.func_74762_e("Facing")];
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tags = new NBTTagCompound();
        this.func_189515_b(tags);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_176201_c(this.field_145850_b.func_180495_p(this.field_174879_c)), tags);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tags = pkt.func_148857_g();
        this.handleUpdateTag(tags);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.func_145839_a(tag);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public void sync() {
        this.func_70296_d();
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            SPacketUpdateTileEntity packetUpdateTileEntity = this.func_189518_D_();
            if (packetUpdateTileEntity == null) {
                return;
            }
            for (EntityPlayerMP player : this.field_145850_b.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
                player.field_71135_a.func_147359_a((Packet)packetUpdateTileEntity);
            }
        }
    }

    public ItemStack storeTileData(ItemStack stack) {
        NBTTagCompound nbttagcompound = this.writeItemData(new NBTTagCompound());
        stack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        return stack;
    }

    @Override
    public void getInformation(@Nonnull List<String> info, IInformationProvider.InformationType type) {
        if (type != IInformationProvider.InformationType.BODY) {
            return;
        }
        info.add(I18n.func_135052_a((String)"hud.msg.power", (Object[])new Object[0]) + ": " + this.getRedstoneState());
    }
}

