/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.compatability;

import de.keridos.floodlights.compatability.IGWSupportNotifier;
import de.keridos.floodlights.handler.ConfigHandler;
import ic2.core.item.tool.ItemToolWrench;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ModCompatibility {
    private static ModCompatibility instance = null;
    public static boolean IC2Loaded = false;
    public static boolean BCLoaded = false;
    public static boolean CofhCoreLoaded = false;
    public static boolean NEILoaded = false;
    public static boolean JEILoaded = false;
    public static boolean EnderIOLoaded = false;
    public static boolean WrenchAvailable = false;
    public static boolean ColoredLightCoreLoaded = false;
    public static boolean ACLoaded = false;

    private ModCompatibility() {
    }

    public static ModCompatibility getInstance() {
        if (instance == null) {
            instance = new ModCompatibility();
        }
        return instance;
    }

    private void checkForMods() {
        IC2Loaded = Loader.isModLoaded((String)"ic2");
        BCLoaded = ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|tools");
        CofhCoreLoaded = ModAPIManager.INSTANCE.hasAPI("cofhapi");
        NEILoaded = Loader.isModLoaded((String)"notenoughitems");
        JEILoaded = Loader.isModLoaded((String)"jei");
        EnderIOLoaded = Loader.isModLoaded((String)"enderio");
        ColoredLightCoreLoaded = Loader.isModLoaded((String)"coloredlightcore");
        ACLoaded = Loader.isModLoaded((String)"agricraft");
    }

    private void addVersionCheckerInfo() {
        NBTTagCompound versionchecker = new NBTTagCompound();
        versionchecker.func_74778_a("curseProjectName", "224728-floodlights");
        versionchecker.func_74778_a("curseFilenameParser", "FloodLights-@MCVERSION@-[]");
        versionchecker.func_74778_a("modDisplayName", "FloodLights");
        versionchecker.func_74778_a("oldVersion", "1.3.2-14");
        FMLInterModComms.sendRuntimeMessage((Object)"floodlights", (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)versionchecker);
    }

    public void performModCompat() {
        this.checkForMods();
        if (ConfigHandler.IGWNotifierEnabled) {
            new IGWSupportNotifier();
        }
        this.addVersionCheckerInfo();
        WrenchAvailable = BCLoaded || EnderIOLoaded || IC2Loaded || CofhCoreLoaded;
    }

    public boolean isItemValidWrench(ItemStack stack) {
        return IC2Loaded && stack.func_77973_b() instanceof ItemToolWrench || stack.func_77973_b().getRegistryName().toString().equals("enderio:item_yeta_wrench") || stack.func_77973_b().getRegistryName().toString().equals("thermalfoundation:wrench") || stack.func_77973_b().getRegistryName().toString().equals("buildcraftcore:wrench");
    }
}

