/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.ndrei.teslacorelib.capabilities.inventory.ISidedItemHandlerConfig;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.FluidTankPiece;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.IGuiContainerPiecesProvider;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredFluidHandler;
import net.ndrei.teslacorelib.inventory.FluidStorage;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010)\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00050\u0004B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ-\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/ndrei/teslacorelib/inventory/SidedFluidHandler;", "Lnet/ndrei/teslacorelib/inventory/FluidStorage;", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "Lnet/ndrei/teslacorelib/gui/IGuiContainerPiecesProvider;", "", "Lnet/minecraftforge/fluids/IFluidTank;", "sidedConfig", "Lnet/ndrei/teslacorelib/capabilities/inventory/ISidedItemHandlerConfig;", "tile", "Lnet/ndrei/teslacorelib/tileentities/SidedTileEntity;", "(Lnet/ndrei/teslacorelib/capabilities/inventory/ISidedItemHandlerConfig;Lnet/ndrei/teslacorelib/tileentities/SidedTileEntity;)V", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getGuiContainerPieces", "", "Lnet/ndrei/teslacorelib/gui/IGuiContainerPiece;", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "getTanksForSide", "", "hasCapability", "", "iterator", "", "tesla-core-lib"})
public final class SidedFluidHandler
extends FluidStorage
implements ICapabilityProvider,
IGuiContainerPiecesProvider,
Iterable<IFluidTank>,
KMappedMarker {
    private final ISidedItemHandlerConfig sidedConfig;
    private final SidedTileEntity tile;

    private final List<IFluidTank> getTanksForSide(EnumFacing facing) {
        ArrayList list = Lists.newArrayList();
        for (IFluidTank tank2 : this.getTanks()) {
            if (!(tank2 instanceof ColoredFluidHandler)) continue;
            EnumDyeColor color = ((ColoredFluidHandler)tank2).getColor();
            if (facing != null && !this.sidedConfig.isSideSet(color, facing)) continue;
            list.add(tank2);
        }
        ArrayList arrayList = list;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"list");
        return arrayList;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            List<IFluidTank> tanks = this.getTanksForSide(facing);
            return tanks.size() > 0;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            List<IFluidTank> tanks = this.getTanksForSide(facing);
            FluidStorage tempStorage = new FluidStorage();
            for (IFluidTank tank2 : tanks) {
                tempStorage.addTank(tank2);
            }
            return (T)tempStorage;
        }
        return null;
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        ArrayList list = Lists.newArrayList();
        for (IFluidTank tank2 : this.getTanks()) {
            BoundingRectangle box;
            if (!(tank2 instanceof ColoredFluidHandler) || (box = ((ColoredFluidHandler)tank2).getBoundingBox()).isEmpty()) continue;
            list.add(new FluidTankPiece(this.tile, ((ColoredFluidHandler)tank2).getColor(), tank2, box.getLeft(), box.getTop()));
        }
        ArrayList arrayList = list;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"list");
        return arrayList;
    }

    @Override
    @NotNull
    public Iterator<IFluidTank> iterator() {
        return this.getTanks().iterator();
    }

    public SidedFluidHandler(@NotNull ISidedItemHandlerConfig sidedConfig, @NotNull SidedTileEntity tile) {
        Intrinsics.checkParameterIsNotNull((Object)sidedConfig, (String)"sidedConfig");
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        this.sidedConfig = sidedConfig;
        this.tile = tile;
    }
}

