/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item;

import it.zerono.mods.zerocore.lib.init.IGameObject;
import it.zerono.mods.zerocore.util.ItemHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class ModItem
extends Item
implements IGameObject {
    private final String _oreDictionaryName;

    @Nonnull
    public ItemStack createItemStack() {
        return ItemHelper.stackFrom(this, 1, 0);
    }

    @Nonnull
    public ItemStack createItemStack(int amount) {
        return ItemHelper.stackFrom(this, amount, 0);
    }

    @Nonnull
    public ItemStack createItemStack(int amount, int meta) {
        return ItemHelper.stackFrom(this, amount, meta);
    }

    @Nullable
    public String getOreDictionaryName() {
        return this._oreDictionaryName;
    }

    @Override
    public void onRegisterItemBlocks(@Nonnull IForgeRegistry<Item> registry) {
    }

    @Override
    public void onRegisterOreDictionaryEntries() {
        String name = this.getOreDictionaryName();
        if (!Strings.isNullOrEmpty((String)name)) {
            OreDictionary.registerOre((String)name, (Item)this);
        }
    }

    @Override
    public void onRegisterRecipes(@Nonnull IForgeRegistry<IRecipe> registry) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegisterModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public int func_77647_b(int metadata) {
        return metadata;
    }

    protected ModItem(@Nonnull String itemName, @Nullable String oreDictionaryName) {
        this._oreDictionaryName = oreDictionaryName;
        this.setRegistryName(itemName);
        this.func_77655_b(this.getRegistryName().toString());
    }

    protected ModItem(@Nonnull String itemName) {
        this(itemName, null);
    }
}

