/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import forestry.arboriculture.models.SimpleModel;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.MultipartBakedModel;
import net.minecraft.client.renderer.block.model.multipart.Multipart;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MultipartModel
implements IModel {
    private final ResourceLocation location;
    private final Multipart multipart;
    private final ImmutableMap<Selector, IModel> partModels;

    public MultipartModel(ResourceLocation location, Multipart multipart) throws Exception {
        this.location = location;
        this.multipart = multipart;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Selector selector : multipart.func_188136_a()) {
            builder.put((Object)selector, (Object)new SimpleModel(location, selector.func_188165_a()));
        }
        this.partModels = builder.build();
    }

    private MultipartModel(ResourceLocation location, Multipart multipart, ImmutableMap<Selector, IModel> partModels) {
        this.location = location;
        this.multipart = multipart;
        this.partModels = partModels;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        MultipartBakedModel.Builder builder = new MultipartBakedModel.Builder();
        for (Selector selector : this.multipart.func_188136_a()) {
            IModel model = (IModel)this.partModels.get((Object)selector);
            IBakedModel bakedModel = model.bake(model.getDefaultState(), format, bakedTextureGetter);
            builder.func_188648_a(selector.func_188166_a(this.multipart.func_188135_c()), bakedModel);
        }
        return builder.func_188647_a();
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        try {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Selector selector : this.multipart.func_188136_a()) {
                SimpleModel model = new SimpleModel(this.location, selector.func_188165_a());
                model = model.retexture(textures);
                builder.put((Object)selector, (Object)model);
            }
            return new MultipartModel(this.location, this.multipart, (ImmutableMap<Selector, IModel>)builder.build());
        }
        catch (Exception e) {
            return this;
        }
    }

    public Multipart getMultipart() {
        return this.multipart;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

