/*
 * Decompiled with CFR 0.152.
 */
package com.raden93.veganlife.util;

import com.raden93.veganlife.block.enderperl.EncrustedObsidianBlock;
import com.raden93.veganlife.util.FluidUtil;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockUtil {
    public static boolean isBlockInOrAdjacentMaterial(World world, BlockPos blockPos, Material material) {
        for (BlockPos position : BlockUtil.getAdjacentBlocks(blockPos)) {
            if (!BlockUtil.isBlockGivenMaterial(world, position, material)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos[] getAdjacentBlocks(BlockPos blockPos) {
        return new BlockPos[]{blockPos.func_177972_a(EnumFacing.NORTH), blockPos.func_177972_a(EnumFacing.SOUTH), blockPos.func_177972_a(EnumFacing.EAST), blockPos.func_177972_a(EnumFacing.WEST), blockPos.func_177972_a(EnumFacing.UP)};
    }

    public static BlockPos[] getAdjacentBlocksHorizontally(BlockPos blockPos) {
        return new BlockPos[]{blockPos.func_177972_a(EnumFacing.NORTH), blockPos.func_177972_a(EnumFacing.SOUTH), blockPos.func_177972_a(EnumFacing.EAST), blockPos.func_177972_a(EnumFacing.WEST)};
    }

    public static boolean isValidPortalLocation(World world, BlockPos blockPos) {
        for (BlockPos blockToCheck : BlockUtil.getAdjacentBlocksHorizontally(blockPos)) {
            if (world.func_180495_p(blockToCheck).func_177230_c() instanceof EncrustedObsidianBlock) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlockGivenMaterial(World world, BlockPos blockPos, Material material) {
        return world.func_180495_p(blockPos).func_185904_a().equals(material);
    }

    public static BlockPos findWaterSource(World world, BlockPos pos) {
        if (!BlockUtil.isBlockGivenMaterial(world, pos, Material.field_151586_h)) {
            return null;
        }
        IBlockState state = world.func_180495_p(pos);
        if (FluidUtil.getFluidLevel(state) == FluidUtil.getStillFluidLevel(state)) {
            return pos;
        }
        return BlockUtil.findWaterSource(world, pos.func_177984_a());
    }

    public static BlockPos[] findAllBlocksAdjust(World world, BlockPos startPos, int distance) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = startPos.func_177958_n() - distance; x < startPos.func_177958_n() + distance; ++x) {
            for (int y = startPos.func_177956_o() - distance; y < startPos.func_177956_o() + distance; ++y) {
                for (int z = startPos.func_177952_p() - distance; z < startPos.func_177952_p() + distance; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    if (BlockUtil.isBlockGivenMaterial(world, currentPos, Material.field_151579_a)) continue;
                    list.add(currentPos);
                }
            }
        }
        BlockPos[] results = new BlockPos[list.size()];
        return list.toArray(results);
    }
}

