/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;

public class Thaumic
extends AbstractTrait {
    public static final Thaumic thaumic = new Thaumic();

    public Thaumic() {
        super("thaumic", 1966182);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onToolBuilding(TinkerEvent.OnItemBuilding event) {
        int count = 0;
        List reqComponents = event.tool.getRequiredComponents();
        int size = reqComponents.size();
        if (event.materials.size() < size) {
            size = event.materials.size();
        }
        for (int i = 0; i < size; ++i) {
            PartMaterialType required = (PartMaterialType)reqComponents.get(i);
            Material material = (Material)event.materials.get(i);
            boolean hasTrait = false;
            for (ITrait trait : required.getApplicableTraitsForMaterial(material)) {
                if (!this.identifier.equals(trait.getIdentifier())) continue;
                hasTrait = true;
                break;
            }
            if (!hasTrait) continue;
            ++count;
        }
        if (count > 0) {
            this.increaseFreeModifiers(event.tag);
        }
        if (count >= Math.min(3, event.tool.getRequiredComponents().size())) {
            this.increaseFreeModifiers(event.tag);
        }
    }

    protected void increaseFreeModifiers(NBTTagCompound rootCompound) {
        NBTTagCompound toolTag = TagUtil.getToolTag((NBTTagCompound)rootCompound);
        int modifiers = toolTag.func_74762_e("FreeModifiers") + 1;
        toolTag.func_74768_a("FreeModifiers", Math.max(0, modifiers));
        TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)toolTag);
    }
}

