/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.fp;

import info.openmods.calc.Calculator;
import info.openmods.calc.Environment;
import info.openmods.calc.ExprType;
import info.openmods.calc.IValuePrinter;
import info.openmods.calc.SimpleCalculatorFactory;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.executable.OperatorDictionary;
import info.openmods.calc.executable.UnaryOperator;
import info.openmods.calc.parsing.BasicCompilerMapFactory;
import info.openmods.calc.parsing.CommonSimpleSymbolFactory;
import info.openmods.calc.parsing.IValueParser;
import info.openmods.calc.symbol.BinaryFunction;
import info.openmods.calc.symbol.GenericFunctions;
import info.openmods.calc.symbol.NullaryFunction;
import info.openmods.calc.symbol.UnaryFunction;
import info.openmods.calc.types.fp.DoubleParser;
import info.openmods.calc.types.fp.DoublePrinter;
import java.util.Random;

public class DoubleCalculatorFactory<M>
extends SimpleCalculatorFactory<Double, M> {
    public static final double NULL_VALUE = 0.0;
    private static final int PRIORITY_POWER = 4;
    private static final int PRIORITY_MULTIPLY = 3;
    private static final int PRIORITY_ADD = 2;
    private static final int PRIORITY_ASSIGN = 1;

    @Override
    protected IValueParser<Double> getValueParser() {
        return new DoubleParser();
    }

    @Override
    protected Double getNullValue() {
        return 0.0;
    }

    @Override
    protected IValuePrinter<Double> createValuePrinter() {
        return new DoublePrinter();
    }

    @Override
    protected void configureEnvironment(Environment<Double> env) {
        env.setGlobalSymbol("PI", Math.PI);
        env.setGlobalSymbol("E", Math.E);
        env.setGlobalSymbol("INF", Double.POSITIVE_INFINITY);
        env.setGlobalSymbol("MAX", (Double)Double.MIN_VALUE);
        env.setGlobalSymbol("abs", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.abs(value);
            }
        }));
        env.setGlobalSymbol("sgn", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.signum(value);
            }
        }));
        env.setGlobalSymbol("sqrt", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.sqrt(value);
            }
        }));
        env.setGlobalSymbol("ceil", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.ceil(value);
            }
        }));
        env.setGlobalSymbol("floor", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.floor(value);
            }
        }));
        env.setGlobalSymbol("cos", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.cos(value);
            }
        }));
        env.setGlobalSymbol("cosh", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.cosh(value);
            }
        }));
        env.setGlobalSymbol("sin", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.sin(value);
            }
        }));
        env.setGlobalSymbol("sinh", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.sinh(value);
            }
        }));
        env.setGlobalSymbol("tan", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.tan(value);
            }
        }));
        env.setGlobalSymbol("tanh", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.tanh(value);
            }
        }));
        env.setGlobalSymbol("acos", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.acos(value);
            }
        }));
        env.setGlobalSymbol("acosh", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.log(value + Math.sqrt(value * value - 1.0));
            }
        }));
        env.setGlobalSymbol("asin", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.asin(value);
            }
        }));
        env.setGlobalSymbol("asinh", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return value.isInfinite() ? value : Math.log(value + Math.sqrt(value * value + 1.0));
            }
        }));
        env.setGlobalSymbol("atan", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.atan(value);
            }
        }));
        env.setGlobalSymbol("atanh", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.log((1.0 + value) / (1.0 - value)) / 2.0;
            }
        }));
        env.setGlobalSymbol("atan2", (Double)((Object)new BinaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double left, Double right) {
                return Math.atan2(left, right);
            }
        }));
        env.setGlobalSymbol("log10", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.log10(value);
            }
        }));
        env.setGlobalSymbol("ln", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.log(value);
            }
        }));
        env.setGlobalSymbol("log", (Double)((Object)new BinaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double left, Double right) {
                return Math.log(left) / Math.log(right);
            }
        }));
        env.setGlobalSymbol("exp", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.exp(value);
            }
        }));
        env.setGlobalSymbol("min", (Double)((Object)new GenericFunctions.DirectAccumulatorFunction<Double>(Double.valueOf(0.0)){

            @Override
            protected Double accumulate(Double result, Double value) {
                return Math.min(result, value);
            }
        }));
        env.setGlobalSymbol("max", (Double)((Object)new GenericFunctions.DirectAccumulatorFunction<Double>(Double.valueOf(0.0)){

            @Override
            protected Double accumulate(Double result, Double value) {
                return Math.max(result, value);
            }
        }));
        env.setGlobalSymbol("sum", (Double)((Object)new GenericFunctions.DirectAccumulatorFunction<Double>(Double.valueOf(0.0)){

            @Override
            protected Double accumulate(Double result, Double value) {
                return result + value;
            }
        }));
        env.setGlobalSymbol("avg", (Double)((Object)new GenericFunctions.DirectAccumulatorFunction<Double>(Double.valueOf(0.0)){

            @Override
            protected Double accumulate(Double result, Double value) {
                return result + value;
            }

            @Override
            protected Double process(Double result, int argCount) {
                return result / (double)argCount;
            }
        }));
        env.setGlobalSymbol("rad", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.toRadians(value);
            }
        }));
        env.setGlobalSymbol("deg", (Double)((Object)new UnaryFunction.Direct<Double>(){

            @Override
            protected Double call(Double value) {
                return Math.toDegrees(value);
            }
        }));
        final Random random = new Random();
        env.setGlobalSymbol("rand", (Double)((Object)new NullaryFunction.Direct<Double>(){

            @Override
            protected Double call() {
                return random.nextDouble();
            }
        }));
        env.setGlobalSymbol("gauss", (Double)((Object)new NullaryFunction.Direct<Double>(){

            @Override
            protected Double call() {
                return random.nextGaussian();
            }
        }));
    }

    @Override
    protected void configureOperators(OperatorDictionary<Operator<Double>> operators) {
        operators.registerOperator(new UnaryOperator.Direct<Double>("neg"){

            @Override
            public Double execute(Double value) {
                return -value.doubleValue();
            }
        });
        operators.registerOperator(new BinaryOperator.Direct<Double>("+", 2){

            @Override
            public Double execute(Double left, Double right) {
                return left + right;
            }
        });
        operators.registerOperator(new UnaryOperator.Direct<Double>("+"){

            @Override
            public Double execute(Double value) {
                return (double)value;
            }
        });
        operators.registerOperator(new BinaryOperator.Direct<Double>("-", 2){

            @Override
            public Double execute(Double left, Double right) {
                return left - right;
            }
        });
        operators.registerOperator(new UnaryOperator.Direct<Double>("-"){

            @Override
            public Double execute(Double value) {
                return -value.doubleValue();
            }
        });
        operators.registerOperator(new BinaryOperator.Direct<Double>("*", 3){

            @Override
            public Double execute(Double left, Double right) {
                return left * right;
            }
        }).setDefault();
        operators.registerOperator(new BinaryOperator.Direct<Double>("/", 3){

            @Override
            public Double execute(Double left, Double right) {
                return left / right;
            }
        });
        operators.registerOperator(new BinaryOperator.Direct<Double>("%", 3){

            @Override
            public Double execute(Double left, Double right) {
                return left % right;
            }
        });
        operators.registerOperator(new BinaryOperator.Direct<Double>("^", 4){

            @Override
            public Double execute(Double left, Double right) {
                return Math.pow(left, right);
            }
        });
        operators.registerOperator(new BinaryOperator.Direct<Double>("**", 4){

            @Override
            public Double execute(Double left, Double right) {
                return Math.pow(left, right);
            }
        });
    }

    public static Calculator<Double, ExprType> createSimple() {
        return new DoubleCalculatorFactory().create(new BasicCompilerMapFactory());
    }

    public static Calculator<Double, ExprType> createDefault() {
        final CommonSimpleSymbolFactory letFactory = new CommonSimpleSymbolFactory(1, ":", "=");
        return new DoubleCalculatorFactory<ExprType>(){

            @Override
            protected void configureOperators(OperatorDictionary<Operator<Double>> operators) {
                super.configureOperators(operators);
                letFactory.registerSeparators(operators);
            }
        }.create(letFactory.createCompilerFactory());
    }
}

