/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.recipes.RecipeRegistryPluginSafeWrapper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import team.chisel.Chisel;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.common.carving.Carving;
import team.chisel.common.init.ChiselItems;
import team.chisel.common.integration.jei.ChiselRecipeCategory;
import team.chisel.common.integration.jei.ChiselRecipeRegistryPlugin;
import team.chisel.common.integration.jei.ChiselRecipeWrapper;

@ParametersAreNonnullByDefault
@JEIPlugin
public class ChiselJEIPlugin
implements IModPlugin {
    private ChiselRecipeCategory category;
    private final ChiselRecipeRegistryPlugin plugin = new ChiselRecipeRegistryPlugin();

    public void register(IModRegistry registry) {
        registry.handleRecipes(ICarvingGroup.class, ChiselRecipeWrapper::new, "chisel.chiseling");
        registry.addRecipes((Collection)Carving.chisel.getSortedGroupNames().stream().map(s -> Carving.chisel.getGroup((String)s)).collect(Collectors.toList()), this.category.getUid());
        Arrays.stream(new Item[]{ChiselItems.chisel_iron, ChiselItems.chisel_diamond, ChiselItems.chisel_hitech}).map(ItemStack::new).forEach(stack -> {
            registry.addRecipeCatalyst(stack, new String[]{this.category.getUid()});
            registry.addIngredientInfo(stack, VanillaTypes.ITEM, new String[]{"jei.chisel.desc.chisel_generic", "\n", "jei.chisel.desc." + stack.func_77973_b().getRegistryName().func_110623_a()});
        });
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 16; ++i) {
            itemStacks.add(new ItemStack(Blocks.field_192444_dS, 1, i));
            itemStacks.add(new ItemStack(Blocks.field_192443_dR, 1, i));
        }
        registry.addIngredientInfo(itemStacks, VanillaTypes.ITEM, new String[]{"jei.chisel.desc.concrete_making"});
        registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)this.plugin);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        try {
            List plugins = (List)ObfuscationReflectionHelper.getPrivateValue(RecipeRegistry.class, (Object)((RecipeRegistry)jeiRuntime.getRecipeRegistry()), (String)"plugins");
            plugins.remove(this.plugin);
            Iterator iter = plugins.iterator();
            while (iter.hasNext()) {
                IRecipeRegistryPlugin wrapped;
                IRecipeRegistryPlugin p = (IRecipeRegistryPlugin)iter.next();
                if (!(p instanceof RecipeRegistryPluginSafeWrapper) || (wrapped = (IRecipeRegistryPlugin)ObfuscationReflectionHelper.getPrivateValue(RecipeRegistryPluginSafeWrapper.class, (Object)((RecipeRegistryPluginSafeWrapper)p), (String)"plugin")) != this.plugin) continue;
                iter.remove();
            }
            plugins.add(0, this.plugin);
        }
        catch (Exception e) {
            Chisel.logger.error("Failed to inject recipe registry plugin at beginning of list, cannot guarantee vanilla recipes will show first", (Throwable)e);
        }
        this.plugin.setRecipeRegistry(jeiRuntime.getRecipeRegistry());
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.category = new ChiselRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.category});
    }
}

