/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.PGPUtilities;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.IgnoreSignaturesValidationStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.RequireAnySignatureValidationStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.RequireSpecificSignatureValidationStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;

public final class SignatureValidationStrategies {
    private SignatureValidationStrategies() {
    }

    public static SignatureValidationStrategy ignoreSignatures() {
        return new IgnoreSignaturesValidationStrategy();
    }

    public static SignatureValidationStrategy requireAnySignature() {
        return new RequireAnySignatureValidationStrategy();
    }

    public static SignatureValidationStrategy requireSignatureFromAllKeys(Collection<Long> signaturesRequiredForTheseKeys) {
        return new RequireSpecificSignatureValidationStrategy(signaturesRequiredForTheseKeys);
    }

    public static SignatureValidationStrategy requireSignatureFromAllKeys(PGPPublicKeyRingCollection publicKeyRings, String ... userIds) throws PGPException {
        ArrayList<Long> keyIds = new ArrayList<Long>(userIds.length);
        for (String userId : userIds) {
            PGPPublicKeyRing pgpPublicKeys = PGPUtilities.extractPublicKeyRingForUserId(userId, publicKeyRings);
            if (pgpPublicKeys == null) {
                throw new PGPException("Could not find public-key for userid '" + userId + "'");
            }
            PGPPublicKey signingKey = PGPUtilities.extractSigningPublicKey(pgpPublicKeys);
            if (signingKey == null) {
                throw new PGPException("Could not find public-key for userid '" + userId + "'");
            }
            keyIds.add(signingKey.getKeyID());
        }
        return new RequireSpecificSignatureValidationStrategy(keyIds);
    }

    public static SignatureValidationStrategy requireSignatureFromAllKeys(Long ... keyIds) {
        return new RequireSpecificSignatureValidationStrategy(Arrays.asList(keyIds));
    }

    public static SignatureValidationStrategy requireSignatureFromAllKeys(long signaturesRequiredForThisKey) {
        return new RequireSpecificSignatureValidationStrategy(Collections.singletonList(signaturesRequiredForThisKey));
    }
}

