/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation;

import java.io.IOException;
import java.security.SignatureException;
import java.util.Map;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RequireAnySignatureValidationStrategy
implements SignatureValidationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequireAnySignatureValidationStrategy.class);

    RequireAnySignatureValidationStrategy() {
    }

    @Override
    public void validateSignatures(PGPObjectFactory factory, Map<Long, PGPOnePassSignature> onePassSignatures) throws SignatureException, PGPException, IOException {
        PGPSignatureList signatureList = (PGPSignatureList)factory.nextObject();
        if (signatureList == null || signatureList.isEmpty()) {
            throw new PGPException("No signatures found!");
        }
        boolean successfullyVerified = false;
        for (PGPSignature messageSignature : signatureList) {
            PGPOnePassSignature ops = onePassSignatures.get(messageSignature.getKeyID());
            if (ops != null) {
                boolean isThisSignatureGood = ops.verify(messageSignature);
                LOGGER.debug("{} validated signature with key 0x{}", (Object)(isThisSignatureGood ? "Successfully" : "Failed to"), (Object)Long.toHexString(messageSignature.getKeyID()));
                successfullyVerified |= isThisSignatureGood;
                continue;
            }
            LOGGER.debug("Could not validated signature with key 0x{} because we have no matching public key", (Object)Long.toHexString(messageSignature.getKeyID()));
        }
        if (!successfullyVerified) {
            throw new SignatureException("Signature verification failed!");
        }
        LOGGER.debug("Signature verification success");
    }

    @Override
    public boolean isRequireSignatureCheck() {
        return true;
    }
}

