/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys;

import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PGPUtilities {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPUtilities.class);

    private PGPUtilities() {
    }

    public static PGPPrivateKey findSecretKey(PGPSecretKeyRingCollection pgpSec, long keyID, char[] pass) throws PGPException {
        LOGGER.debug("Finding secret key with key ID '0x{}'", (Object)Long.toHexString(keyID));
        PGPSecretKey pgpSecKey = pgpSec.getSecretKey(keyID);
        if (pgpSecKey == null) {
            return null;
        }
        return PGPUtilities.extractPrivateKey(pgpSecKey, pass);
    }

    public static PGPPrivateKey extractPrivateKey(PGPSecretKey encryptedKey, char[] passphrase) throws PGPException {
        LOGGER.debug("Extracting secret key with key ID '0x{}'", (Object)Long.toHexString(encryptedKey.getKeyID()));
        PGPDigestCalculatorProvider calcProvider = new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build();
        PBESecretKeyDecryptor decryptor = new JcePBESecretKeyDecryptorBuilder(calcProvider).setProvider("BC").build(passphrase);
        return encryptedKey.extractPrivateKey(decryptor);
    }

    public static PGPPublicKeyRing extractPublicKeyRingForUserId(String publicKeyUid, PGPPublicKeyRingCollection publicKeyRings) throws PGPException {
        if (publicKeyUid == null) {
            throw new NullPointerException("publicKeyUid must not be null");
        }
        if (publicKeyRings == null) {
            throw new NullPointerException("publicKeyRings must not be null");
        }
        Iterator<PGPPublicKeyRing> keyRings = publicKeyRings.getKeyRings("<" + publicKeyUid + ">", true);
        PGPPublicKeyRing returnKeyRing = null;
        while (keyRings.hasNext()) {
            PGPPublicKeyRing currentKeyRing = keyRings.next();
            if (!(currentKeyRing instanceof PGPPublicKeyRing)) continue;
            if (returnKeyRing == null) {
                returnKeyRing = currentKeyRing;
                continue;
            }
            throw new PGPException("Multiple public key rings found for UID '" + publicKeyUid + "'!");
        }
        if (returnKeyRing == null) {
            throw new PGPException("No public key ring found for UID '" + publicKeyUid + "'!");
        }
        LOGGER.debug("Extracted public key ring for UID '{}' with key strength {}.", (Object)publicKeyUid, (Object)returnKeyRing.getPublicKey().getBitStrength());
        return returnKeyRing;
    }

    public static PGPPublicKey extractSigningPublicKey(PGPPublicKeyRing keyring) {
        int highestScore = Integer.MIN_VALUE;
        PGPPublicKey ret = null;
        for (PGPPublicKey pubKey : keyring) {
            int score = PGPUtilities.calculateSigningKeyScore(pubKey);
            if (score <= highestScore) continue;
            ret = pubKey;
            highestScore = score;
        }
        return ret;
    }

    private static int calculateSigningKeyScore(PGPPublicKey pubKey) {
        int score = 0;
        if (!pubKey.isMasterKey()) {
            score += 100;
        }
        if (!pubKey.isEncryptionKey()) {
            score += 10;
        }
        return score;
    }

    public static PGPSecretKey extractSecretSigningKeyFromKeyrings(PGPSecretKeyRingCollection pgpSec, String signingKeyUid) throws PGPException {
        int highestScore = Integer.MIN_VALUE;
        PGPSecretKey key = null;
        Iterator<PGPSecretKeyRing> ringIterator = pgpSec.getKeyRings("<" + signingKeyUid + ">", true);
        while (ringIterator.hasNext()) {
            PGPSecretKeyRing kRing = ringIterator.next();
            Iterator<PGPSecretKey> secretKeyIterator = kRing.getSecretKeys();
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey k = secretKeyIterator.next();
                int score = PGPUtilities.calculateSigningKeyScore(k.getPublicKey());
                if (!k.isSigningKey() || score <= highestScore) continue;
                key = k;
                highestScore = score;
            }
        }
        if (key == null) {
            throw new PGPException(String.format("Can't find signing key for uid '%s' in key ring.", signingKeyUid));
        }
        LOGGER.trace("Extracted secret signing key for UID '{}'.", (Object)signingKeyUid);
        return key;
    }

    public static PGPPublicKey getEncryptionKey(PGPPublicKeyRing publicKeyRing) {
        int highestScore = Integer.MIN_VALUE;
        PGPPublicKey returnKey = null;
        for (PGPPublicKey pubKey : publicKeyRing) {
            int score = PGPUtilities.calculateEncryptionKeyScore(pubKey);
            if (score <= highestScore) continue;
            returnKey = pubKey;
            highestScore = score;
        }
        return returnKey;
    }

    private static int calculateEncryptionKeyScore(PGPPublicKey pubKey) {
        if (!pubKey.isEncryptionKey()) {
            return Integer.MIN_VALUE;
        }
        int score = 0;
        if (!pubKey.isMasterKey()) {
            ++score;
        }
        return score;
    }
}

