/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.encrypting;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.util.Date;
import java.util.Iterator;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPAlgorithmSuite;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.PGPUtilities;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PGPEncryptingStream
extends OutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPEncryptingStream.class);
    private final KeyringConfig config;
    private final PGPAlgorithmSuite algorithmSuite;
    private boolean isDoSign;
    private OutputStream encryptionDataStream;
    private PGPSignatureGenerator signatureGenerator;
    @Nullable
    private ArmoredOutputStream armoredOutputStream;
    private OutputStream outerEncryptionStream;
    private BCPGOutputStream compressionStream;
    private PGPLiteralDataGenerator encryptionDataStreamGenerator;
    private PGPCompressedDataGenerator compressionStreamGenerator;

    private PGPEncryptingStream(KeyringConfig config, PGPAlgorithmSuite algorithmSuite) {
        this.config = config;
        this.algorithmSuite = algorithmSuite;
    }

    public static OutputStream create(KeyringConfig config, PGPAlgorithmSuite algorithmSuite, String signingUid, OutputStream cipherTextSink, boolean armor, PGPPublicKey pubEncKey) throws IOException, PGPException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        if (config == null) {
            throw new NullPointerException("No config");
        }
        if (cipherTextSink == null) {
            throw new NullPointerException("no cipherTextSink");
        }
        if (pubEncKey == null) {
            throw new NullPointerException("No pubEncKey");
        }
        if (!pubEncKey.isEncryptionKey()) {
            throw new PGPException(String.format("This public key (0x%x) is not suitable for encryption", pubEncKey.getKeyID()));
        }
        PGPEncryptingStream encryptingStream = new PGPEncryptingStream(config, algorithmSuite);
        encryptingStream.setup(cipherTextSink, signingUid, pubEncKey, armor);
        return encryptingStream;
    }

    private void setup(OutputStream cipherTextSink, @Nullable String signingUid, PGPPublicKey pubEncKey, boolean armor) throws IOException, PGPException {
        OutputStream sink;
        boolean bl = this.isDoSign = signingUid != null;
        if (armor) {
            this.armoredOutputStream = new ArmoredOutputStream(cipherTextSink);
            sink = this.armoredOutputStream;
        } else {
            sink = cipherTextSink;
        }
        BcPGPDataEncryptorBuilder dataEncryptorBuilder = new BcPGPDataEncryptorBuilder(this.algorithmSuite.getSymmetricEncryptionAlgorithmCode().id);
        dataEncryptorBuilder.setWithIntegrityPacket(true);
        PGPEncryptedDataGenerator cPk = new PGPEncryptedDataGenerator(dataEncryptorBuilder);
        cPk.addMethod(new BcPublicKeyKeyEncryptionMethodGenerator(pubEncKey));
        this.outerEncryptionStream = cPk.open(sink, new byte[65536]);
        if (this.isDoSign) {
            PGPSecretKey pgpSec = PGPUtilities.extractSecretSigningKeyFromKeyrings(this.config.getSecretKeyRings(), signingUid);
            PGPPrivateKey pgpPrivKey = PGPUtilities.extractPrivateKey(pgpSec, this.config.decryptionSecretKeyPassphraseForSecretKeyId(pgpSec.getKeyID()));
            this.signatureGenerator = new PGPSignatureGenerator(new BcPGPContentSignerBuilder(pgpSec.getPublicKey().getAlgorithm(), this.algorithmSuite.getHashAlgorithmCode().id));
            this.signatureGenerator.init(0, pgpPrivKey);
            Iterator<String> it = pgpSec.getPublicKey().getUserIDs();
            if (it.hasNext()) {
                PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
                spGen.setSignerUserID(false, it.next());
                this.signatureGenerator.setHashedSubpackets(spGen.generate());
            }
        }
        this.compressionStreamGenerator = new PGPCompressedDataGenerator(this.algorithmSuite.getCompressionEncryptionAlgorithmCode().id);
        this.compressionStream = new BCPGOutputStream(this.compressionStreamGenerator.open(this.outerEncryptionStream));
        if (this.isDoSign) {
            this.signatureGenerator.generateOnePassVersion(false).encode(this.compressionStream);
        }
        this.encryptionDataStreamGenerator = new PGPLiteralDataGenerator();
        this.encryptionDataStream = this.encryptionDataStreamGenerator.open((OutputStream)this.compressionStream, 'b', "", new Date(), new byte[65536]);
    }

    @Override
    public void write(int b) throws IOException {
        this.encryptionDataStream.write(b);
        if (this.isDoSign) {
            byte asByte = (byte)(b & 0xFF);
            this.signatureGenerator.update(asByte);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        this.encryptionDataStream.write(buffer, 0, len);
        if (this.isDoSign) {
            this.signatureGenerator.update(buffer, 0, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.encryptionDataStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.encryptionDataStream.flush();
        this.encryptionDataStream.close();
        this.encryptionDataStreamGenerator.close();
        if (this.isDoSign) {
            try {
                this.signatureGenerator.generate().encode(this.compressionStream);
            }
            catch (PGPException e) {
                throw new IOException(e);
            }
        }
        this.compressionStreamGenerator.close();
        this.outerEncryptionStream.flush();
        this.outerEncryptionStream.close();
        if (this.armoredOutputStream != null) {
            this.armoredOutputStream.flush();
            this.armoredOutputStream.close();
        }
    }
}

