/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.decrypting.DecryptionStreamFactory;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategies;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import org.bouncycastle.openpgp.PGPException;

public final class BuildDecryptionInputStreamAPI {
    @Nonnull
    private KeyringConfig keyringConfig;
    @Nonnull
    private SignatureValidationStrategy signatureCheckingMode;

    BuildDecryptionInputStreamAPI() {
    }

    @Nonnull
    public Validation withConfig(@Nullable KeyringConfig keyringConfig) {
        if (keyringConfig == null) {
            throw new IllegalArgumentException("keyringConfig must not be null");
        }
        this.keyringConfig = keyringConfig;
        return new Validation();
    }

    public final class Validation {
        @Nonnull
        public Build andRequireSignatureFromAllKeys(Long ... publicKeyIds) {
            if (publicKeyIds == null || publicKeyIds.length == 0) {
                throw new IllegalArgumentException("publicKeyIds must not be null or empty");
            }
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.requireSignatureFromAllKeys(publicKeyIds);
            return new Builder();
        }

        @Nonnull
        public Build andRequireSignatureFromAllKeys(String ... userIds) throws PGPException, IOException {
            if (userIds == null || userIds.length == 0) {
                throw new IllegalArgumentException("userIds must not be null or empty");
            }
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.requireSignatureFromAllKeys(BuildDecryptionInputStreamAPI.this.keyringConfig.getPublicKeyRings(), userIds);
            return new Builder();
        }

        @Nonnull
        public Build andValidateSomeoneSigned() {
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.requireAnySignature();
            return new Builder();
        }

        @Nonnull
        public Build andIgnoreSignatures() {
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.ignoreSignatures();
            return new Builder();
        }

        public final class Builder
        implements Build {
            @Override
            @Nonnull
            public InputStream fromEncryptedInputStream(@Nullable InputStream encryptedData) throws IOException, NoSuchProviderException {
                if (encryptedData == null) {
                    throw new IllegalArgumentException("encryptedData must not be null");
                }
                DecryptionStreamFactory pgpInputStreamFactory = DecryptionStreamFactory.create(BuildDecryptionInputStreamAPI.this.keyringConfig, BuildDecryptionInputStreamAPI.this.signatureCheckingMode);
                return pgpInputStreamFactory.wrapWithDecryptAndVerify(encryptedData);
            }
        }
    }

    public static interface Build {
        @Nonnull
        public InputStream fromEncryptedInputStream(@Nullable InputStream var1) throws IOException, NoSuchProviderException;
    }
}

