/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.lexicon;

import com.sun.speech.freetts.lexicon.LetterToSound;
import com.sun.speech.freetts.lexicon.LetterToSoundImpl;
import com.sun.speech.freetts.lexicon.Lexicon;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class LexiconImpl
implements Lexicon {
    protected boolean tokenizeOnLoad = false;
    protected boolean tokenizeOnLookup = false;
    private static final int MAGIC = 12237598;
    private static final int VERSION = 1;
    private URL compiledURL;
    private URL addendaURL;
    private URL letterToSoundURL;
    private Map addenda;
    private Map compiled;
    private LetterToSound letterToSound = null;
    private ArrayList partsOfSpeech = new ArrayList();
    private static Map loadedCompiledLexicons;
    private boolean loaded = false;
    private boolean binary = false;
    private static final String[] NO_PHONES;
    private char[] charBuffer = new char[128];
    private boolean useNewIO = Utilities.getProperty("com.sun.speech.freetts.useNewIO", "true").equals("true");

    public LexiconImpl(URL compiledURL, URL addendaURL, URL letterToSoundURL, boolean binary) {
        this();
        this.setLexiconParameters(compiledURL, addendaURL, letterToSoundURL, binary);
    }

    public LexiconImpl() {
        String tokenize = Utilities.getProperty("com.sun.speech.freetts.lexicon.LexTokenize", "never");
        this.tokenizeOnLoad = tokenize.equals("load");
        this.tokenizeOnLookup = tokenize.equals("lookup");
    }

    protected void setLexiconParameters(URL compiledURL, URL addendaURL, URL letterToSoundURL, boolean binary) {
        this.compiledURL = compiledURL;
        this.addendaURL = addendaURL;
        this.letterToSoundURL = letterToSoundURL;
        this.binary = binary;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void load() throws IOException {
        BulkTimer.LOAD.start("Lexicon");
        if (this.compiledURL == null) {
            throw new IOException("Can't load lexicon");
        }
        if (this.addendaURL == null) {
            throw new IOException("Can't load lexicon addenda ");
        }
        if (loadedCompiledLexicons == null) {
            loadedCompiledLexicons = new HashMap();
        }
        if (!loadedCompiledLexicons.containsKey(this.compiledURL)) {
            InputStream compiledIS = Utilities.getInputStream(this.compiledURL);
            if (compiledIS == null) {
                throw new IOException("Can't load lexicon from " + this.compiledURL);
            }
            Map newCompiled = this.createLexicon(compiledIS, this.binary, 65000);
            loadedCompiledLexicons.put(this.compiledURL, newCompiled);
            compiledIS.close();
        }
        this.compiled = Collections.unmodifiableMap((Map)loadedCompiledLexicons.get(this.compiledURL));
        InputStream addendaIS = Utilities.getInputStream(this.addendaURL);
        if (addendaIS == null) {
            throw new IOException("Can't load lexicon addenda from " + this.addendaURL);
        }
        this.addenda = this.createLexicon(addendaIS, this.binary, 50);
        addendaIS.close();
        String userAddenda = Utilities.getProperty("com.sun.speech.freetts.lexicon.userAddenda", null);
        if (userAddenda != null) {
            try {
                URL userAddendaURL = new URL(userAddenda);
                InputStream userAddendaIS = Utilities.getInputStream(userAddendaURL);
                if (userAddendaIS == null) {
                    throw new IOException("Can't load user addenda from " + userAddenda);
                }
                Map tmpAddenda = this.createLexicon(userAddendaIS, false, 50);
                userAddendaIS.close();
                for (Object key : tmpAddenda.keySet()) {
                    this.addenda.put(key, tmpAddenda.get(key));
                }
            }
            catch (MalformedURLException e) {
                throw new IOException("User addenda URL is malformed: " + userAddenda);
            }
        }
        this.loaded = true;
        BulkTimer.LOAD.stop("Lexicon");
        this.letterToSound = new LetterToSoundImpl(this.letterToSoundURL, this.binary);
    }

    protected Map createLexicon(InputStream is, boolean binary, int estimatedSize) throws IOException {
        if (binary) {
            if (this.useNewIO && is instanceof FileInputStream) {
                FileInputStream fis = (FileInputStream)is;
                return this.loadMappedBinaryLexicon(fis, estimatedSize);
            }
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            return this.loadBinaryLexicon(dis, estimatedSize);
        }
        return this.loadTextLexicon(is, estimatedSize);
    }

    protected Map loadTextLexicon(InputStream is, int estimatedSize) throws IOException {
        LinkedHashMap lexicon = new LinkedHashMap(estimatedSize * 4 / 3);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = reader.readLine();
        while (line != null) {
            if (!line.startsWith("***")) {
                this.parseAndAdd(lexicon, line);
            }
            line = reader.readLine();
        }
        return lexicon;
    }

    protected void parseAndAdd(Map lexicon, String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, "\t");
        String phones = null;
        String wordAndPos = tokenizer.nextToken();
        String pos = wordAndPos.substring(wordAndPos.length() - 1);
        if (!this.partsOfSpeech.contains(pos)) {
            this.partsOfSpeech.add(pos);
        }
        if (tokenizer.hasMoreTokens()) {
            phones = tokenizer.nextToken();
        }
        if (phones != null && this.tokenizeOnLoad) {
            lexicon.put(wordAndPos, this.getPhones(phones));
        } else if (phones == null) {
            lexicon.put(wordAndPos, NO_PHONES);
        } else {
            lexicon.put(wordAndPos, phones);
        }
    }

    @Override
    public String[] getPhones(String word, String partOfSpeech) {
        return this.getPhones(word, partOfSpeech, true);
    }

    @Override
    public String[] getPhones(String word, String partOfSpeech, boolean useLTS) {
        String[] phones = null;
        phones = this.getPhones(this.addenda, word, partOfSpeech);
        if (phones == null) {
            phones = this.getPhones(this.compiled, word, partOfSpeech);
        }
        if (useLTS && phones == null && this.letterToSound != null) {
            phones = this.letterToSound.getPhones(word, partOfSpeech);
        }
        if (phones != null) {
            String[] copy = new String[phones.length];
            System.arraycopy(phones, 0, copy, 0, phones.length);
            return copy;
        }
        return null;
    }

    protected String[] getPhones(Map lexicon, String word, String partOfSpeech) {
        partOfSpeech = LexiconImpl.fixPartOfSpeech(partOfSpeech);
        String[] phones = this.getPhones(lexicon, word + partOfSpeech);
        for (int i = 0; i < this.partsOfSpeech.size() && phones == null; ++i) {
            if (partOfSpeech.equals((String)this.partsOfSpeech.get(i))) continue;
            phones = this.getPhones(lexicon, word + (String)this.partsOfSpeech.get(i));
        }
        return phones;
    }

    protected String[] getPhones(Map lexicon, String wordAndPartOfSpeech) {
        Object value = lexicon.get(wordAndPartOfSpeech);
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            String[] phoneArray = this.getPhones((String)value);
            if (this.tokenizeOnLookup) {
                lexicon.put(wordAndPartOfSpeech, phoneArray);
            }
            return phoneArray;
        }
        return null;
    }

    protected String[] getPhones(String phones) {
        ArrayList<String> phoneList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(phones, " ");
        while (tokenizer.hasMoreTokens()) {
            phoneList.add(tokenizer.nextToken());
        }
        return phoneList.toArray(new String[0]);
    }

    @Override
    public void addAddendum(String word, String partOfSpeech, String[] phones) {
        String pos = LexiconImpl.fixPartOfSpeech(partOfSpeech);
        if (!this.partsOfSpeech.contains(pos)) {
            this.partsOfSpeech.add(pos);
        }
        this.addenda.put(word + pos, phones);
    }

    @Override
    public void removeAddendum(String word, String partOfSpeech) {
        this.addenda.remove(word + LexiconImpl.fixPartOfSpeech(partOfSpeech));
    }

    private void outString(DataOutputStream dos, String s) throws IOException {
        dos.writeByte((byte)s.length());
        for (int i = 0; i < s.length(); ++i) {
            dos.writeChar(s.charAt(i));
        }
    }

    private String getString(DataInputStream dis) throws IOException {
        int size = dis.readByte();
        for (int i = 0; i < size; ++i) {
            this.charBuffer[i] = dis.readChar();
        }
        return new String(this.charBuffer, 0, size);
    }

    private String getString(ByteBuffer bb) throws IOException {
        int size = bb.get();
        for (int i = 0; i < size; ++i) {
            this.charBuffer[i] = bb.getChar();
        }
        return new String(this.charBuffer, 0, size);
    }

    private void dumpBinaryLexicon(Map lexicon, String path) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos));
            List phonemeList = this.findPhonemes(lexicon);
            dos.writeInt(12237598);
            dos.writeInt(1);
            dos.writeInt(phonemeList.size());
            for (int i = 0; i < phonemeList.size(); ++i) {
                this.outString(dos, (String)phonemeList.get(i));
            }
            dos.writeInt(lexicon.keySet().size());
            for (String key : lexicon.keySet()) {
                this.outString(dos, key);
                String[] phonemes = this.getPhones(lexicon, key);
                dos.writeByte((byte)phonemes.length);
                for (int index = 0; index < phonemes.length; ++index) {
                    int phonemeIndex = phonemeList.indexOf(phonemes[index]);
                    if (phonemeIndex == -1) {
                        throw new Error("Can't find phoneme index");
                    }
                    dos.writeByte((byte)phonemeIndex);
                }
            }
            dos.close();
        }
        catch (FileNotFoundException fe) {
            throw new Error("Can't dump binary database " + fe.getMessage());
        }
        catch (IOException ioe) {
            throw new Error("Can't write binary database " + ioe.getMessage());
        }
    }

    private Map loadMappedBinaryLexicon(FileInputStream is, int estimatedSize) throws IOException {
        int i;
        FileChannel fc = is.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        bb.load();
        int size = 0;
        int numEntries = 0;
        ArrayList<String> phonemeList = new ArrayList<String>();
        LinkedHashMap<String, String[]> lexicon = new LinkedHashMap<String, String[]>(estimatedSize * 4 / 3);
        if (bb.getInt() != 12237598) {
            throw new Error("bad magic number in lexicon");
        }
        if (bb.getInt() != 1) {
            throw new Error("bad version number in lexicon");
        }
        size = bb.getInt();
        for (i = 0; i < size; ++i) {
            String phoneme = this.getString(bb);
            phonemeList.add(phoneme);
        }
        numEntries = bb.getInt();
        for (i = 0; i < numEntries; ++i) {
            String wordAndPos = this.getString(bb);
            String pos = Character.toString(wordAndPos.charAt(wordAndPos.length() - 1));
            if (!this.partsOfSpeech.contains(pos)) {
                this.partsOfSpeech.add(pos);
            }
            int numPhonemes = bb.get();
            String[] phonemes = new String[numPhonemes];
            for (int j = 0; j < numPhonemes; ++j) {
                phonemes[j] = (String)phonemeList.get(bb.get());
            }
            lexicon.put(wordAndPos, phonemes);
        }
        fc.close();
        return lexicon;
    }

    private Map loadBinaryLexicon(InputStream is, int estimatedSize) throws IOException {
        int i;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
        int size = 0;
        int numEntries = 0;
        ArrayList<String> phonemeList = new ArrayList<String>();
        LinkedHashMap<String, String[]> lexicon = new LinkedHashMap<String, String[]>();
        if (dis.readInt() != 12237598) {
            throw new Error("bad magic number in lexicon");
        }
        if (dis.readInt() != 1) {
            throw new Error("bad version number in lexicon");
        }
        size = dis.readInt();
        for (i = 0; i < size; ++i) {
            String phoneme = this.getString(dis);
            phonemeList.add(phoneme);
        }
        numEntries = dis.readInt();
        for (i = 0; i < numEntries; ++i) {
            String wordAndPos = this.getString(dis);
            String pos = Character.toString(wordAndPos.charAt(wordAndPos.length() - 1));
            if (!this.partsOfSpeech.contains(pos)) {
                this.partsOfSpeech.add(pos);
            }
            int numPhonemes = dis.readByte();
            String[] phonemes = new String[numPhonemes];
            for (int j = 0; j < numPhonemes; ++j) {
                phonemes[j] = (String)phonemeList.get(dis.readByte());
            }
            lexicon.put(wordAndPos, phonemes);
        }
        dis.close();
        return lexicon;
    }

    public void dumpBinary(String path) {
        String compiledPath = path + "_compiled.bin";
        String addendaPath = path + "_addenda.bin";
        this.dumpBinaryLexicon(this.compiled, compiledPath);
        this.dumpBinaryLexicon(this.addenda, addendaPath);
    }

    private List findPhonemes(Map lexicon) {
        ArrayList<String> phonemeList = new ArrayList<String>();
        for (String key : lexicon.keySet()) {
            String[] phonemes = this.getPhones(lexicon, key);
            for (int index = 0; index < phonemes.length; ++index) {
                if (phonemeList.contains(phonemes[index])) continue;
                phonemeList.add(phonemes[index]);
            }
        }
        return phonemeList;
    }

    public boolean compare(LexiconImpl other) {
        return this.compare(this.addenda, other.addenda) && this.compare(this.compiled, other.compiled);
    }

    private boolean compare(Map lex, Map other) {
        for (String key : lex.keySet()) {
            String[] thisPhonemes = this.getPhones(lex, key);
            String[] otherPhonemes = this.getPhones(other, key);
            if (thisPhonemes == null) {
                System.out.println(key + " not found in this.");
                return false;
            }
            if (otherPhonemes == null) {
                System.out.println(key + " not found in other.");
                return false;
            }
            if (thisPhonemes.length == otherPhonemes.length) {
                for (int j = 0; j < thisPhonemes.length; ++j) {
                    if (thisPhonemes[j].equals(otherPhonemes[j])) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    protected static String fixPartOfSpeech(String partOfSpeech) {
        return partOfSpeech == null ? "0" : partOfSpeech;
    }

    static {
        NO_PHONES = new String[0];
    }
}

