/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.DynamicClassLoader;
import com.sun.speech.freetts.UniqueVector;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceDirectory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.Attributes;

public class VoiceManager {
    private static final VoiceManager INSTANCE;
    private static final String PATH_SEPARATOR;
    private static final DynamicClassLoader classLoader;

    private VoiceManager() {
    }

    public static VoiceManager getInstance() {
        return INSTANCE;
    }

    public Voice[] getVoices() {
        Collection<VoiceDirectory> voiceDirectories;
        UniqueVector<Voice> voices = new UniqueVector<Voice>();
        try {
            voiceDirectories = this.getVoiceDirectories();
        }
        catch (IOException e) {
            throw new Error(e.getMessage(), e);
        }
        for (VoiceDirectory dir : voiceDirectories) {
            voices.addArray(dir.getVoices());
        }
        Voice[] voiceArray = new Voice[voices.size()];
        return voices.toArray(voiceArray);
    }

    public String getVoiceInfo() {
        Collection<VoiceDirectory> voiceDirectories;
        StringBuilder infoString = new StringBuilder();
        try {
            voiceDirectories = this.getVoiceDirectories();
        }
        catch (IOException e) {
            throw new Error(e.getMessage(), e);
        }
        for (VoiceDirectory dir : voiceDirectories) {
            infoString.append(dir.toString());
        }
        return infoString.toString();
    }

    private Collection<VoiceDirectory> getVoiceDirectories() throws IOException {
        try {
            String voiceClasses = System.getProperty("freetts.voices");
            if (voiceClasses != null) {
                return this.getVoiceDirectoryNamesFromProperty(voiceClasses);
            }
            UniqueVector<String> voiceDirectoryNames = this.getVoiceDirectoryNamesFromFiles();
            UniqueVector<URL> pathURLs = this.getVoiceJarURLs();
            voiceDirectoryNames.addVector(this.getVoiceDirectoryNamesFromJarURLs(pathURLs));
            URL[] voiceJarURLs = pathURLs.toArray((URL[])new URL[pathURLs.size()]);
            for (int i = 0; i < voiceJarURLs.length; ++i) {
                this.getDependencyURLs(voiceJarURLs[i], pathURLs);
            }
            boolean noexpansion = Boolean.getBoolean("freetts.nocpexpansion");
            if (!noexpansion) {
                for (int i = 0; i < pathURLs.size(); ++i) {
                    classLoader.addUniqueURL(pathURLs.get(i));
                }
            }
            UniqueVector voiceDirectories = new UniqueVector();
            for (int i = 0; i < voiceDirectoryNames.size(); ++i) {
                Class<?> c = Class.forName(voiceDirectoryNames.get(i), true, classLoader);
                voiceDirectories.add(c.newInstance());
            }
            return voiceDirectories.elements();
        }
        catch (InstantiationException e) {
            throw new Error("Unable to load voice directory. " + e);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Unable to load voice directory. " + e);
        }
        catch (IllegalAccessException e) {
            throw new Error("Unable to load voice directory. " + e);
        }
    }

    private Collection<VoiceDirectory> getVoiceDirectoryNamesFromProperty(String voiceClasses) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] classnames = voiceClasses.split(",");
        ArrayList<VoiceDirectory> directories = new ArrayList<VoiceDirectory>();
        for (int i = 0; i < classnames.length; ++i) {
            Class<?> c = classLoader.loadClass(classnames[i]);
            directories.add((VoiceDirectory)c.newInstance());
        }
        return directories;
    }

    private void getDependencyURLs(URL url, UniqueVector<URL> dependencyURLs) throws IOException {
        String urlDirName = this.getURLDirName(url);
        if (url.getProtocol().equals("jar")) {
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            Attributes attributes = jarConnection.getMainAttributes();
            String fullClassPath = attributes.getValue(Attributes.Name.CLASS_PATH);
            if (fullClassPath == null || fullClassPath.equals("")) {
                return;
            }
            String[] classPath = fullClassPath.split("\\s+");
            for (int i = 0; i < classPath.length; ++i) {
                URL classPathURL;
                try {
                    classPathURL = classPath[i].endsWith("/") ? new URL("file:" + urlDirName + classPath[i]) : new URL("jar", "", "file:" + urlDirName + classPath[i] + "!/");
                }
                catch (MalformedURLException e) {
                    System.err.println("Warning: unable to resolve dependency " + classPath[i] + " referenced by " + url);
                    continue;
                }
                if (dependencyURLs.contains(classPathURL)) continue;
                dependencyURLs.add(classPathURL);
                this.getDependencyURLs(classPathURL, dependencyURLs);
            }
        }
    }

    private UniqueVector<String> getVoiceDirectoryNamesFromFiles() throws IOException {
        UniqueVector<String> voiceDirectoryNames = new UniqueVector<String>();
        InputStream is = this.getClass().getResourceAsStream("internal_voices.txt");
        if (is != null) {
            voiceDirectoryNames.addVector(this.getVoiceDirectoryNamesFromInputStream(is));
        }
        try {
            voiceDirectoryNames.addVector(this.getVoiceDirectoryNamesFromFile(this.getBaseDirectory() + "voices.txt"));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        String voicesFile = System.getProperty("freetts.voicesfile");
        if (voicesFile != null) {
            voiceDirectoryNames.addVector(this.getVoiceDirectoryNamesFromFile(voicesFile));
        }
        return voiceDirectoryNames;
    }

    private UniqueVector<String> getVoiceDirectoryNamesFromJarURLs(UniqueVector<URL> urls) {
        try {
            UniqueVector<String> voiceDirectoryNames = new UniqueVector<String>();
            for (int i = 0; i < urls.size(); ++i) {
                JarURLConnection jarConnection = (JarURLConnection)urls.get(i).openConnection();
                Attributes attributes = jarConnection.getMainAttributes();
                String mainClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
                if (mainClass == null || mainClass.trim().equals("")) {
                    throw new Error("No Main-Class found in jar " + urls.get(i));
                }
                voiceDirectoryNames.add(mainClass);
            }
            return voiceDirectoryNames;
        }
        catch (IOException e) {
            throw new Error("Error reading jarfile manifests.");
        }
    }

    private UniqueVector<URL> getVoiceJarURLs() {
        UniqueVector<URL> voiceJarURLs = new UniqueVector<URL>();
        try {
            String baseDirectory = this.getBaseDirectory();
            if (!baseDirectory.equals("")) {
                voiceJarURLs.addVector(this.getVoiceJarURLsFromDir(baseDirectory));
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        String voicesPath = System.getProperty("freetts.voicespath", "");
        if (!voicesPath.equals("")) {
            String[] dirNames = voicesPath.split(PATH_SEPARATOR);
            for (int i = 0; i < dirNames.length; ++i) {
                try {
                    voiceJarURLs.addVector(this.getVoiceJarURLsFromDir(dirNames[i]));
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new Error("Error loading jars from voicespath " + dirNames[i] + ". ");
                }
            }
        }
        return voiceJarURLs;
    }

    private UniqueVector<URL> getVoiceJarURLsFromDir(String dirName) throws FileNotFoundException {
        try {
            UniqueVector<URL> voiceJarURLs = new UniqueVector<URL>();
            File dir = new File(new URI("file://" + dirName));
            if (!dir.isDirectory()) {
                throw new FileNotFoundException("File is not a directory: " + dirName);
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String isVoice;
                File file = files[i];
                if (!file.isFile() || file.isHidden() || !file.getName().endsWith(".jar")) continue;
                URL jarURL = file.toURI().toURL();
                jarURL = new URL("jar", "", "file:" + jarURL.getPath() + "!/");
                JarURLConnection jarConnection = (JarURLConnection)jarURL.openConnection();
                Attributes attributes = jarConnection.getMainAttributes();
                if (attributes == null || (isVoice = attributes.getValue("FreeTTSVoiceDefinition")) == null || !isVoice.trim().equals("true")) continue;
                voiceJarURLs.add(jarURL);
            }
            return voiceJarURLs;
        }
        catch (URISyntaxException e) {
            throw new Error("Error reading directory name '" + dirName + "'.");
        }
        catch (MalformedURLException e) {
            throw new Error("Error reading jars from directory " + dirName + ". ");
        }
        catch (IOException e) {
            throw new Error("Error reading jars from directory " + dirName + ". ");
        }
    }

    public String toString() {
        StringBuilder names = new StringBuilder();
        Voice[] voices = this.getVoices();
        for (int i = 0; i < voices.length; ++i) {
            if (i == voices.length - 1) {
                if (i == 0) {
                    names.append(voices[i].getName());
                    continue;
                }
                names.append("or ");
                names.append(voices[i].getName());
                continue;
            }
            names.append(voices[i].getName());
            names.append(" ");
        }
        return names.toString();
    }

    public boolean contains(String voiceName) {
        return this.getVoice(voiceName) != null;
    }

    public Voice getVoice(String voiceName) {
        Voice[] voices = this.getVoices();
        for (int i = 0; i < voices.length; ++i) {
            if (!voices[i].getName().equals(voiceName)) continue;
            return voices[i];
        }
        return null;
    }

    private String getBaseDirectory() {
        String name = this.getClass().getName();
        int lastdot = name.lastIndexOf(46);
        if (lastdot != -1) {
            name = name.substring(lastdot + 1);
        }
        URL url = this.getClass().getResource(name + ".class");
        return this.getURLDirName(url);
    }

    private String getURLDirName(URL url) {
        String urlFileName = url.getPath();
        int i = urlFileName.lastIndexOf(33);
        if (i == -1) {
            i = urlFileName.length();
        }
        int dir = urlFileName.lastIndexOf("/", i);
        if (!urlFileName.startsWith("file:")) {
            return "";
        }
        return urlFileName.substring(5, dir) + "/";
    }

    private UniqueVector<String> getVoiceDirectoryNamesFromFile(String fileName) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(fileName);
        if (is == null) {
            throw new IOException();
        }
        return this.getVoiceDirectoryNamesFromInputStream(is);
    }

    private UniqueVector<String> getVoiceDirectoryNamesFromInputStream(InputStream is) throws IOException {
        String line;
        UniqueVector<String> names = new UniqueVector<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
            names.add(line);
        }
        return names;
    }

    public static URLClassLoader getVoiceClassLoader() {
        return classLoader;
    }

    static {
        PATH_SEPARATOR = System.getProperty("path.separator");
        INSTANCE = new VoiceManager();
        ClassLoader parent = VoiceManager.class.getClassLoader();
        classLoader = new DynamicClassLoader(new URL[0], parent);
    }
}

