/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils.rfid;

import com.austinv11.peripheralsplusplus.utils.rfid.DataFormatException;
import com.austinv11.peripheralsplusplus.utils.rfid.RfidTag;
import java.util.Arrays;

public class RfidAuthentication {
    private static final byte[] EMPTY_BLOCK = new byte[16];
    private final RfidTag.KeyType keyType;
    private final int block;
    private final byte[] key;

    public RfidAuthentication(RfidTag.KeyType keyType, int block, byte[] key) {
        this.keyType = keyType;
        this.block = block;
        this.key = key;
    }

    public byte[] readBlock(RfidTag rfidTag, int blockIndex) {
        boolean[] perms;
        if (!this.isSameSector(blockIndex)) {
            return EMPTY_BLOCK;
        }
        if (blockIndex == 0) {
            return rfidTag.getBlock(blockIndex);
        }
        try {
            perms = this.verifyAndGetAccessBits(rfidTag, blockIndex);
        }
        catch (DataFormatException e) {
            return EMPTY_BLOCK;
        }
        if (!this.verifyKey(rfidTag, blockIndex)) {
            return EMPTY_BLOCK;
        }
        byte[] block = rfidTag.getBlock(blockIndex);
        if (this.isSectorTrailer(blockIndex)) {
            byte[] nullKey = new byte[RfidTag.DEFAULT_KEY.length];
            System.arraycopy(nullKey, 0, block, 0, nullKey.length);
            switch (this.keyType) {
                case A: {
                    if (this.hasPerm(perms, 0, 0, 0) || this.hasPerm(perms, 0, 1, 0) || this.hasPerm(perms, 0, 0, 1)) break;
                    System.arraycopy(nullKey, 0, block, 10, nullKey.length);
                    break;
                }
                case B: {
                    if (this.hasPerm(perms, 0, 0, 0) || this.hasPerm(perms, 0, 1, 0) || this.hasPerm(perms, 0, 0, 1)) {
                        byte[] nullBits = new byte[RfidTag.DEFAULT_ACCESS_BYTES.length];
                        System.arraycopy(nullBits, 0, block, RfidTag.ACCESS_BITS_POSITION, nullBits.length);
                    }
                    System.arraycopy(nullKey, 0, block, 10, nullKey.length);
                }
            }
            return block;
        }
        if (this.hasPerm(perms, 1, 1, 1)) {
            return EMPTY_BLOCK;
        }
        switch (this.keyType) {
            case A: {
                if (!this.hasPerm(perms, 0, 1, 1) && !this.hasPerm(perms, 1, 0, 1)) break;
                return EMPTY_BLOCK;
            }
            case B: {
                if (!this.isKeyBReadable(rfidTag, blockIndex)) break;
                return EMPTY_BLOCK;
            }
        }
        return block;
    }

    private boolean isSameSector(int blockIndex) {
        return this.getSectorTrailerIndex(blockIndex) == this.getSectorTrailerIndex(this.block);
    }

    private boolean isKeyBReadable(RfidTag rfidTag, int blockIndex) {
        boolean[] perms;
        try {
            perms = this.verifyAndGetAccessBits(rfidTag, this.getSectorTrailerIndex(blockIndex));
        }
        catch (DataFormatException e) {
            return false;
        }
        return this.hasPerm(perms, 0, 0, 0) || this.hasPerm(perms, 0, 1, 0) || this.hasPerm(perms, 0, 0, 1);
    }

    private boolean isSectorTrailer(int blockIndex) {
        return this.getSectorTrailerIndex(blockIndex) == blockIndex;
    }

    private boolean verifyKey(RfidTag rfidTag, int blockIndex) {
        int sectorTrailerIndex = this.getSectorTrailerIndex(blockIndex);
        byte[] sectorTrailer = rfidTag.getBlock(sectorTrailerIndex);
        byte[] keyA = new byte[RfidTag.DEFAULT_KEY.length];
        System.arraycopy(sectorTrailer, 0, keyA, 0, keyA.length);
        byte[] keyB = new byte[RfidTag.DEFAULT_KEY.length];
        System.arraycopy(sectorTrailer, 10, keyB, 0, keyB.length);
        return !(this.keyType.equals((Object)RfidTag.KeyType.A) && !Arrays.equals(this.key, keyA) || this.keyType.equals((Object)RfidTag.KeyType.B) && !Arrays.equals(this.key, keyB));
    }

    private boolean[] verifyAndGetAccessBits(RfidTag rfidTag, int blockIndex) throws DataFormatException {
        int sectorTrailerIndex = this.getSectorTrailerIndex(blockIndex);
        byte[] sectorTrailer = rfidTag.getBlock(sectorTrailerIndex);
        byte[] accessBytes = new byte[RfidTag.DEFAULT_ACCESS_BYTES.length];
        System.arraycopy(sectorTrailer, RfidTag.ACCESS_BITS_POSITION, accessBytes, 0, RfidTag.DEFAULT_ACCESS_BYTES.length);
        if (!this.verifyAccessBitsFormat(accessBytes)) {
            throw new DataFormatException();
        }
        return this.getAccessBits(accessBytes, blockIndex % 4);
    }

    private boolean hasPerm(boolean[] perms, int one, int two, int three) {
        return this.hasPerm(perms, one == 1, two == 1, three == 1);
    }

    private boolean hasPerm(boolean[] perms, boolean one, boolean two, boolean three) {
        return Arrays.equals(perms, new boolean[]{one, two, three});
    }

    private boolean[] getAccessBits(byte[] accessBytes, int accessBitsIndex) {
        boolean[] bitsRaw = this.getAccessBitsRaw(accessBytes, accessBitsIndex);
        boolean[] bits = new boolean[bitsRaw.length / 2];
        bits[0] = bitsRaw[4];
        bits[1] = bitsRaw[2];
        bits[2] = bitsRaw[5];
        return bits;
    }

    private boolean verifyAccessBitsFormat(byte[] accessBytes) {
        if (accessBytes.length != RfidTag.DEFAULT_ACCESS_BYTES.length) {
            return false;
        }
        for (int accessBitsIndex = 0; accessBitsIndex < 4; ++accessBitsIndex) {
            boolean[] accessBits = this.getAccessBitsRaw(accessBytes, accessBitsIndex);
            if (accessBits[4] != accessBits[0] && accessBits[2] != accessBits[3] && accessBits[5] != accessBits[1]) continue;
            return false;
        }
        return true;
    }

    private boolean[] getAccessBitsRaw(byte[] accessBytes, int accessBitsIndex) {
        int bitsSize = RfidTag.DEFAULT_ACCESS_BYTES.length - 1;
        boolean[] bits = new boolean[bitsSize * 2];
        int mask = 1;
        for (int bitIndex = 0; bitIndex < bitsSize; ++bitIndex) {
            bits[bitIndex] = (accessBytes[bitIndex] & mask << accessBitsIndex) >> accessBitsIndex == 1;
            bits[bitIndex + bitsSize] = (accessBytes[bitIndex] & mask << accessBitsIndex + bitsSize + 1) >> accessBitsIndex + bitsSize + 1 == 1;
        }
        return bits;
    }

    private int getSectorTrailerIndex(int block) {
        if ((block + 1) % 4 == 0) {
            return block;
        }
        return block + 4 - (block + 1) % 4;
    }

    public void writeBlock(RfidTag rfidTag, int blockIndex, byte[] data) {
        boolean[] perms;
        if (this.block == 0 || !this.isSameSector(blockIndex)) {
            return;
        }
        try {
            perms = this.verifyAndGetAccessBits(rfidTag, blockIndex);
        }
        catch (DataFormatException e) {
            return;
        }
        if (!this.verifyKey(rfidTag, blockIndex)) {
            return;
        }
        byte[] block = rfidTag.getBlock(blockIndex);
        if (this.isSectorTrailer(blockIndex)) {
            switch (this.keyType) {
                case A: {
                    if (this.hasPerm(perms, 0, 0, 0) || this.hasPerm(perms, 0, 0, 1)) {
                        System.arraycopy(data, 0, block, 0, RfidTag.DEFAULT_KEY.length);
                        System.arraycopy(data, 10, block, 10, RfidTag.DEFAULT_KEY.length);
                    }
                    if (!this.hasPerm(perms, 0, 0, 1)) break;
                    System.arraycopy(data, RfidTag.ACCESS_BITS_POSITION, block, RfidTag.ACCESS_BITS_POSITION, RfidTag.DEFAULT_ACCESS_BYTES.length);
                    break;
                }
                case B: {
                    if (this.hasPerm(perms, 1, 0, 0) || this.hasPerm(perms, 0, 1, 1)) {
                        System.arraycopy(data, 0, block, 0, RfidTag.DEFAULT_KEY.length);
                        System.arraycopy(data, 10, block, 10, RfidTag.DEFAULT_KEY.length);
                    }
                    if (!this.hasPerm(perms, 0, 1, 1) && !this.hasPerm(perms, 1, 0, 1)) break;
                    System.arraycopy(data, RfidTag.ACCESS_BITS_POSITION, block, RfidTag.ACCESS_BITS_POSITION, RfidTag.DEFAULT_ACCESS_BYTES.length);
                }
            }
        } else {
            switch (this.keyType) {
                case A: {
                    if (!this.hasPerm(perms, 0, 0, 0)) break;
                    block = data;
                    break;
                }
                case B: {
                    if (this.isKeyBReadable(rfidTag, blockIndex)) {
                        return;
                    }
                    if (!this.hasPerm(perms, 0, 0, 0) && !this.hasPerm(perms, 1, 0, 0) && !this.hasPerm(perms, 1, 1, 0) && !this.hasPerm(perms, 0, 1, 1)) break;
                    block = data;
                }
            }
        }
        rfidTag.setBlock(block, blockIndex);
    }
}

