/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.proxy.LuaApi;
import com.austinv11.peripheralsplusplus.utils.proxy.PeripheralChangeListener;
import com.austinv11.peripheralsplusplus.utils.proxy.Task;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class ReflectionHelper {
    private static ArrayList<Integer> usedIds = new ArrayList();

    public static ITurtleAccess getTurtle(TileEntity te) throws Exception {
        Method getAccess;
        ITurtleAccess turtle;
        if (te instanceof ITurtleAccess) {
            return (ITurtleAccess)te;
        }
        Class<?> teClass = te.getClass();
        if ((teClass.getName().equals("dan200.computercraft.shared.turtle.blocks.TileTurtleExpanded") || teClass.getName().equals("dan200.computercraft.shared.turtle.blocks.TileTurtleAdvanced") || teClass.getName().equals("dan200.computercraft.shared.turtle.blocks.TileTurtle")) && (turtle = (ITurtleAccess)(getAccess = teClass.getMethod("getAccess", new Class[0])).invoke((Object)te, new Object[0])) != null) {
            return turtle;
        }
        return null;
    }

    @Nullable
    public static Object getICompFromId(int id) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Class<?> computerRegistry = Class.forName("dan200.computercraft.shared.computer.core.ComputerRegistry");
        Method getCompFromId = computerRegistry.getMethod("lookup", Integer.TYPE);
        Object registry = Class.forName("dan200.computercraft.ComputerCraft").getField("serverComputerRegistry").get(null);
        return getCompFromId.invoke(registry, id);
    }

    public static Object objectToLuaValue(Object o) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> luaMachine = Class.forName("dan200.computercraft.core.lua.LuaJLuaMachine");
        Object machine = luaMachine.newInstance();
        Method toVal = luaMachine.getDeclaredMethod("toValue", Object.class);
        toVal.setAccessible(true);
        return toVal.invoke(machine, o);
    }

    @Nullable
    public static Object getLuaMachineFromId(int id) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        Object iComp = ReflectionHelper.getICompFromId(id);
        if (iComp == null) {
            return null;
        }
        Class<?> iCompClass = iComp.getClass().asSubclass(Class.forName("dan200.computercraft.shared.computer.core.ServerComputer"));
        Field compField = ReflectionHelper.findField(iCompClass, "m_computer");
        compField.setAccessible(true);
        Object comp = compField.get(iComp);
        Class<?> compClass = comp.getClass();
        Field machine = compClass.getDeclaredField("m_machine");
        machine.setAccessible(true);
        return machine.get(comp);
    }

    public static void runProgram(String path, int id) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, NoSuchFieldException, InstantiationException {
        Object machineObject = ReflectionHelper.getLuaMachineFromId(id);
        if (machineObject == null) {
            return;
        }
        Class<?> machineClass = machineObject.getClass();
        Field globals = machineClass.getDeclaredField("m_globals");
        globals.setAccessible(true);
        Object globalsObj = globals.get(machineObject);
        Method load = globalsObj.getClass().getDeclaredMethod("get", Class.forName("org.luaj.vm2.LuaValue"));
        load.setAccessible(true);
        Object chunk = load.invoke(globalsObj, ReflectionHelper.objectToLuaValue("os"));
        Method get_ = chunk.getClass().getDeclaredMethod("get", Class.forName("org.luaj.vm2.LuaValue"));
        get_.setAccessible(true);
        Object run = get_.invoke(chunk, ReflectionHelper.objectToLuaValue("run"));
        Method call = run.getClass().getDeclaredMethod("call", Class.forName("org.luaj.vm2.LuaValue"), Class.forName("org.luaj.vm2.LuaValue"));
        call.invoke(run, Class.forName("org.luaj.vm2.LuaTable").newInstance(), ReflectionHelper.objectToLuaValue(path));
    }

    public static void registerAPI(final int id, final LuaApi api) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        if (!Config.enableAPIs || usedIds.contains(id)) {
            return;
        }
        Object o = ReflectionHelper.getLuaMachineFromId(id);
        if (o == null) {
            new Thread("Computer API"){
                private boolean work;
                {
                    super(x0);
                    this.work = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (this.work) {
                        try {
                            1 var2_1 = this;
                            synchronized (var2_1) {
                                this.wait(20L);
                            }
                            Object serverComputerObject = ReflectionHelper.getICompFromId(id);
                            if (serverComputerObject == null) {
                                return;
                            }
                            Class<?> serverCompClass = serverComputerObject.getClass().asSubclass(Class.forName("dan200.computercraft.shared.computer.core.ServerComputer"));
                            Field comp = ReflectionHelper.findField(serverCompClass, "m_computer");
                            comp.setAccessible(true);
                            Object o = comp.get(serverComputerObject);
                            Method addAPI = o.getClass().getDeclaredMethod("addAPI", Class.forName("dan200.computercraft.core.apis.ILuaAPI"));
                            addAPI.invoke(o, Proxy.newProxyInstance(Class.forName("dan200.computercraft.core.apis.ILuaAPI").getClassLoader(), new Class[]{Class.forName("dan200.computercraft.core.apis.ILuaAPI")}, (InvocationHandler)api));
                            Method reboot = o.getClass().getDeclaredMethod("reboot", new Class[0]);
                            reboot.invoke(o, new Object[0]);
                            this.work = false;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
            usedIds.add(id);
            return;
        }
        Method addAPI = o.getClass().getDeclaredMethod("addAPI", Class.forName("dan200.computercraft.core.apis.ILuaAPI"));
        addAPI.invoke(o, Proxy.newProxyInstance(Class.forName("dan200.computercraft.core.apis.ILuaAPI").getClassLoader(), new Class[]{Class.forName("dan200.computercraft.core.apis.ILuaAPI")}, (InvocationHandler)api));
    }

    @Nullable
    public static Object getApiEnvironment(Object computerServer) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        if (computerServer instanceof Integer) {
            Object computer = ReflectionHelper.getICompFromId((Integer)computerServer);
            if (computer == null) {
                return null;
            }
            Class<?> serverCompClass = computer.getClass().asSubclass(Class.forName("dan200.computercraft.shared.computer.core.ServerComputer"));
            Method getAPIEnvironment = ReflectionHelper.findMethod(serverCompClass, "getAPIEnvironment", new Class[0]);
            return getAPIEnvironment.invoke(computer, new Object[0]);
        }
        Class<?> serverCompClass = computerServer.getClass().asSubclass(Class.forName("dan200.computercraft.shared.computer.core.ServerComputer"));
        Field computerField = ReflectionHelper.findField(serverCompClass, "m_computer");
        computerField.setAccessible(true);
        Object computer = computerField.get(computerServer);
        Field id = computer.getClass().getDeclaredField("m_id");
        id.setAccessible(true);
        return ReflectionHelper.getApiEnvironment(id.get(computer));
    }

    private static Field findField(Class clazz, String fieldName) throws NoSuchFieldException {
        Field found = null;
        Class searchClass = clazz;
        while (found == null && searchClass != null) {
            try {
                found = searchClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ignore) {
                searchClass = searchClass.getSuperclass();
            }
        }
        if (found == null) {
            throw new NoSuchFieldException(clazz.getName() + fieldName);
        }
        found.setAccessible(true);
        return found;
    }

    private static Method findMethod(Class clazz, String methodName, Class ... params) throws NoSuchMethodException {
        Method found = null;
        Class searchClass = clazz;
        while (found == null && searchClass != null) {
            try {
                found = searchClass.getDeclaredMethod(methodName, params);
            }
            catch (NoSuchMethodException ignore) {
                searchClass = searchClass.getSuperclass();
            }
        }
        if (found == null) {
            throw new NoSuchMethodException(clazz.getName() + methodName + Arrays.toString(params));
        }
        found.setAccessible(true);
        return found;
    }

    public static Collection<Object> getServerComputers() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Class<?> computerRegistry = Class.forName("dan200.computercraft.shared.computer.core.ComputerRegistry");
        Method getComputers = computerRegistry.getMethod("getComputers", new Class[0]);
        Object registry = Class.forName("dan200.computercraft.ComputerCraft").getField("serverComputerRegistry").get(null);
        return (Collection)getComputers.invoke(registry, new Object[0]);
    }

    public static IPeripheral getPeripheral(Object computer, int side) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> serverCompClass = computer.getClass().asSubclass(Class.forName("dan200.computercraft.shared.computer.core.ServerComputer"));
        Method getPeripheral = ReflectionHelper.findMethod(serverCompClass, "getPeripheral", Integer.TYPE);
        return (IPeripheral)getPeripheral.invoke(computer, side);
    }

    @Nullable
    public static Object getPeripheralChangeListener(Object computer) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Object apiEnvironment = ReflectionHelper.getApiEnvironment(computer);
        if (apiEnvironment == null) {
            return null;
        }
        Class<?> apiEnvironmentClass = Class.forName("dan200.computercraft.core.computer.Computer$APIEnvironment");
        Field peripheralListener = ReflectionHelper.findField(apiEnvironmentClass, "m_peripheralListener");
        return peripheralListener.get(apiEnvironment);
    }

    public static void setPeripheralChangeListener(Object computer, PeripheralChangeListener peripheralChangeListener) throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Object apiEnvironment = ReflectionHelper.getApiEnvironment(computer);
        if (apiEnvironment == null) {
            return;
        }
        Class<?> apiEnvironmentClass = Class.forName("dan200.computercraft.core.computer.Computer$APIEnvironment");
        Class<?> peripheralChangedListenerClass = Class.forName("dan200.computercraft.core.apis.IAPIEnvironment$IPeripheralChangeListener");
        Method setPeripheralChangeListener = ReflectionHelper.findMethod(apiEnvironmentClass, "setPeripheralChangeListener", peripheralChangedListenerClass);
        setPeripheralChangeListener.invoke(apiEnvironment, Proxy.newProxyInstance(peripheralChangedListenerClass.getClassLoader(), new Class[]{peripheralChangedListenerClass}, (InvocationHandler)peripheralChangeListener));
    }

    public static void onPeripheralChanged(int side, IPeripheral newPeripheral, Object peripheralChangeListener) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class<?> peripheralChangeListenerClass = peripheralChangeListener.getClass().asSubclass(Class.forName("dan200.computercraft.core.apis.IAPIEnvironment$IPeripheralChangeListener"));
        Method onPeripheralChanged = ReflectionHelper.findMethod(peripheralChangeListenerClass, "onPeripheralChanged", Integer.TYPE, IPeripheral.class);
        onPeripheralChanged.invoke(peripheralChangeListener, side, newPeripheral);
    }

    public static Object wrapPeripheral(IPeripheral peripheral, String side) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<?> peripheralWrapper = Class.forName("dan200.computercraft.core.apis.PeripheralAPI$PeripheralWrapper").getConstructor(IPeripheral.class, String.class);
        return peripheralWrapper.newInstance(peripheral, side);
    }

    public static String sideIntToString(int side) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> computer = Class.forName("dan200.computercraft.core.computer");
        String[] names = (String[])ReflectionHelper.findField(computer, "s_sideNames").get(null);
        return names[side];
    }

    @Nullable
    public static Object getPeripheralWrapperFromChangeListener(Object peripheralChangeListener, int side) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        if (peripheralChangeListener == null) {
            return null;
        }
        Class<?> peripheralApi = Class.forName("dan200.computercraft.core.apis.PeripheralAPI");
        Field peripheralsField = ReflectionHelper.findField(peripheralApi, "m_peripherals");
        peripheralsField.setAccessible(true);
        Object peripherals = peripheralsField.get(peripheralChangeListener);
        return Array.get(peripherals, side);
    }

    public static void queueTask(Task task, Object queueComputer) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> computerThread = Class.forName("dan200.computercraft.core.computer.ComputerThread");
        Class<?> iTask = Class.forName("dan200.computercraft.core.computer.ITask");
        Class<?> computer = Class.forName("dan200.computercraft.core.computer.Computer");
        Method queueTask = ReflectionHelper.findMethod(computerThread, "queueTask", iTask, computer);
        queueTask.invoke(computerThread, Proxy.newProxyInstance(iTask.getClassLoader(), new Class[]{iTask}, (InvocationHandler)task), queueComputer);
    }

    @Nullable
    public static BlockPos getPos(Object computer) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> serverCompClass = computer.getClass().asSubclass(Class.forName("dan200.computercraft.shared.computer.core.ServerComputer"));
        Field position = ReflectionHelper.findField(serverCompClass, "m_position");
        return (BlockPos)position.get(computer);
    }

    public static boolean isWrappedPeripheralAttached(Object wrappedPeripheral) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> peripheralWrapper = Class.forName("dan200.computercraft.core.apis.PeripheralAPI$PeripheralWrapper");
        Field attached = ReflectionHelper.findField(peripheralWrapper, "m_attached");
        return (Boolean)attached.get(wrappedPeripheral);
    }
}

