/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.network.ChatPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ChatUtil {
    public static void sendMessage(TileEntity te, String text, double range, boolean unlimitedY) {
        if (range == Double.MAX_VALUE) {
            for (WorldServer worldServer : DimensionManager.getWorlds()) {
                for (EntityPlayer player : worldServer.field_73010_i) {
                    PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new ChatPacket(text), (EntityPlayerMP)player);
                }
            }
        } else if (unlimitedY) {
            for (EntityPlayer player : te.func_145831_w().field_73010_i) {
                Vec3d playerPos = new Vec3d(player.field_70165_t, (double)te.func_174877_v().func_177956_o(), player.field_70161_v);
                if (playerPos.func_72438_d(new Vec3d((double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p())) > range) continue;
                PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new ChatPacket(text), (EntityPlayerMP)player);
            }
        } else {
            PeripheralsPlusPlus.NETWORK.sendToAllAround((IMessage)new ChatPacket(text), new NetworkRegistry.TargetPoint(te.func_145831_w().field_73011_w.getDimension(), (double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p(), range));
        }
    }

    public static boolean sendMessage(String ign, TileEntity te, String text, double range, boolean unlimitedY) {
        EntityPlayer player = ChatUtil.getPlayer(ign, range == Double.MAX_VALUE ? null : te.func_145831_w());
        if (player != null) {
            Vec3d playerPos = new Vec3d(player.field_70165_t, unlimitedY ? (double)te.func_174877_v().func_177956_o() : player.field_70163_u, player.field_70161_v);
            Vec3d vec3d = new Vec3d((double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p());
            if (playerPos.func_72438_d(vec3d) > range) {
                return false;
            }
            PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new ChatPacket(text), (EntityPlayerMP)player);
            return true;
        }
        return false;
    }

    private static EntityPlayer getPlayer(String ign, World w) {
        List players = new ArrayList();
        if (w == null) {
            for (WorldServer worldServer : DimensionManager.getWorlds()) {
                players.addAll(worldServer.field_73010_i);
            }
        } else {
            players = w.field_73010_i;
        }
        for (EntityPlayer p : players) {
            if (!p.getDisplayNameString().equalsIgnoreCase(ign)) continue;
            return p;
        }
        return null;
    }

    public static String getCoordsPrefix(TileEntity te) {
        return "[#" + te.func_174877_v().func_177958_n() + "," + te.func_174877_v().func_177956_o() + "," + te.func_174877_v().func_177952_p() + "] ";
    }

    public static String getCoordsPrefix(Entity ent) {
        return "[#" + ent.field_70165_t + "," + ent.field_70163_u + "," + ent.field_70161_v + "] ";
    }
}

