/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class PeripheralTank
implements IPlusPlusPeripheral {
    private static final int TRANSFER_AMOUNT = 1000;
    private ITurtleAccess turtle;
    private TurtleSide side;
    private FluidTank fluidTank = new FluidTank(Config.maxNumberOfMillibuckets);

    public PeripheralTank(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
        if (!turtle.getWorld().field_72995_K) {
            NBTTagCompound turtleTag = turtle.getUpgradeNBTData(side);
            NBTTagCompound tankData = turtleTag.func_74775_l("TankData");
            this.fluidTank = this.fluidTank.readFromNBT(tankData);
        }
    }

    public String getType() {
        return "tank";
    }

    public String[] getMethodNames() {
        return new String[]{"getFluid", "fill", "drain", "place", "placeUp", "placeDown", "suck", "suckUp", "suckDown"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return this.getFluid();
            }
            case 1: {
                return this.fill(this.getFirstArgumentAsSlot(arguments));
            }
            case 2: {
                return this.drain(this.getFirstArgumentAsSlot(arguments));
            }
            case 3: 
            case 4: 
            case 5: {
                return this.emptyToWorld(this.getMethodIdAsDirection(method));
            }
            case 6: 
            case 7: 
            case 8: {
                return this.suckFromWorld(this.getMethodIdAsDirection(method));
            }
        }
        throw new LuaException("Unhandled method");
    }

    private EnumFacing getMethodIdAsDirection(int method) throws LuaException {
        switch (method) {
            case 3: 
            case 6: {
                return this.turtle.getDirection();
            }
            case 4: 
            case 7: {
                return EnumFacing.UP;
            }
            case 5: 
            case 8: {
                return EnumFacing.DOWN;
            }
        }
        throw new LuaException("Unhandled method direction mapping: " + method);
    }

    private Object[] suckFromWorld(EnumFacing direction) throws LuaException {
        BlockPos pos = this.turtle.getPosition().func_177972_a(direction);
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)this.turtle.getWorld(), (BlockPos)pos, (EnumFacing)direction.func_176734_d());
        if (fluidHandler == null) {
            throw new LuaException("Block is not a fluid block");
        }
        FluidStack fluidStack = FluidUtil.tryFluidTransfer((IFluidHandler)this.fluidTank, (IFluidHandler)fluidHandler, (int)1000, (boolean)true);
        if (fluidStack == null) {
            return new Object[]{0};
        }
        this.saveTankDataToTurtle();
        Block block = this.turtle.getWorld().func_180495_p(pos).func_177230_c();
        if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
            this.turtle.getWorld().func_175698_g(pos);
        }
        return new Object[]{fluidStack.amount};
    }

    private Object[] emptyToWorld(EnumFacing direction) {
        boolean placed = FluidUtil.tryPlaceFluid(null, (World)this.turtle.getWorld(), (BlockPos)this.turtle.getPosition().func_177972_a(direction), (IFluidHandler)this.fluidTank, (FluidStack)this.fluidTank.getFluid());
        int amount = 0;
        if (placed) {
            amount = 1000;
            this.saveTankDataToTurtle();
        } else {
            FluidStack transferResult;
            BlockPos pos = this.turtle.getPosition().func_177972_a(direction);
            IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)this.turtle.getWorld(), (BlockPos)pos, (EnumFacing)direction.func_176734_d());
            if (fluidHandler != null && (transferResult = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.fluidTank, (int)1000, (boolean)true)) != null) {
                amount = transferResult.amount;
                this.saveTankDataToTurtle();
            }
        }
        return new Object[]{amount};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFirstArgumentAsSlot(Object[] arguments) throws LuaException {
        if (arguments.length <= 1) return this.turtle.getSelectedSlot();
        if (!(arguments[0] instanceof Double)) throw new LuaException("Bad argument #1 (expected number)");
        int drainSlot = (int)((Double)arguments[0]).doubleValue();
        if (drainSlot < 1) throw new LuaException("Slot index out of bounds");
        if (drainSlot <= this.turtle.getInventory().func_70302_i_()) return drainSlot;
        throw new LuaException("Slot index out of bounds");
    }

    private Object[] drain(int drainSlot) throws LuaException {
        ItemStack drainStack = this.turtle.getInventory().func_70301_a(drainSlot);
        FluidStack drainFluidStack = FluidUtil.getFluidContained((ItemStack)drainStack);
        IFluidHandlerItem drainFluidHandler = FluidUtil.getFluidHandler((ItemStack)drainStack);
        if (drainFluidStack == null || drainFluidHandler == null || drainFluidStack.amount <= 0) {
            throw new LuaException("Item does not contain fluid");
        }
        if (this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(drainFluidStack)) {
            throw new LuaException("Fluid types do not match");
        }
        FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)this.fluidTank, (IFluidHandler)drainFluidHandler, (int)Config.maxNumberOfMillibuckets, (boolean)true);
        if (transfer == null) {
            return new Object[]{0};
        }
        this.turtle.getInventory().func_70299_a(drainSlot, drainFluidHandler.getContainer());
        this.saveTankDataToTurtle();
        return new Object[]{transfer.amount};
    }

    private Object[] fill(int fillSlot) throws LuaException {
        ItemStack fillStack = this.turtle.getInventory().func_70301_a(fillSlot);
        FluidStack fillFluidStack = FluidUtil.getFluidContained((ItemStack)fillStack);
        IFluidHandlerItem fillFluidHandler = FluidUtil.getFluidHandler((ItemStack)fillStack);
        if (fillFluidHandler == null) {
            throw new LuaException("Item cannot contain fluid");
        }
        if (this.fluidTank.getFluid() == null) {
            throw new LuaException("Internal tank does not contain fluid");
        }
        if (fillFluidStack != null && !this.fluidTank.getFluid().equals((Object)fillFluidStack)) {
            throw new LuaException("Fluid types do not match");
        }
        FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fillFluidHandler, (IFluidHandler)this.fluidTank, (int)Config.maxNumberOfMillibuckets, (boolean)true);
        if (transfer == null) {
            return new Object[]{0};
        }
        this.turtle.getInventory().func_70299_a(fillSlot, fillFluidHandler.getContainer());
        this.saveTankDataToTurtle();
        return new Object[]{transfer.amount};
    }

    private Object[] getFluid() {
        if (this.fluidTank.getFluid() != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("amount", this.fluidTank.getFluidAmount());
            map.put("name", this.fluidTank.getFluid().getLocalizedName());
            map.put("id", this.fluidTank.getFluid().getFluid().getName());
            map.put("registered", FluidRegistry.isFluidRegistered((Fluid)this.fluidTank.getFluid().getFluid()));
            return new Object[]{map};
        }
        return new Object[0];
    }

    private void saveTankDataToTurtle() {
        NBTTagCompound newTag = new NBTTagCompound();
        NBTTagCompound turtleTag = this.turtle.getUpgradeNBTData(this.side);
        this.fluidTank.writeToNBT(newTag);
        turtleTag.func_74782_a("TankData", (NBTBase)newTag);
        this.turtle.updateUpgradeNBTData(this.side);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }
}

