/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import net.minecraft.block.BlockSign;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class PeripheralSignReader
implements IPlusPlusPeripheral {
    private ITurtleAccess turtle;

    public PeripheralSignReader(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "signReader";
    }

    public String[] getMethodNames() {
        return new String[]{"read", "readUp", "readDown"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableReaderTurtle) {
            throw new LuaException("Sign Reading Turtles have been disabled");
        }
        switch (method) {
            case 0: {
                return this.getSignText(this.turtle.getPosition().func_177972_a(this.turtle.getDirection()));
            }
            case 1: {
                return this.getSignText(this.turtle.getPosition().func_177984_a());
            }
            case 2: {
                return this.getSignText(this.turtle.getPosition().func_177977_b());
            }
        }
        throw new LuaException();
    }

    private Object[] getSignText(BlockPos pos) throws LuaException {
        IBlockState blockFacing = this.turtle.getWorld().func_180495_p(pos);
        if (blockFacing.func_177230_c() instanceof BlockSign) {
            TileEntitySign tileEntitySign = (TileEntitySign)this.turtle.getWorld().func_175625_s(pos);
            if (tileEntitySign == null) {
                throw new LuaException("No sign found.");
            }
            ArrayList<String> lines = new ArrayList<String>();
            for (ITextComponent line : tileEntitySign.field_145915_a) {
                lines.add(line.func_150260_c());
            }
            return new Object[]{Util.arrayToMap(lines.toArray())};
        }
        throw new LuaException("No sign found.");
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }
}

