/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class PeripheralChunkLoader
implements IPlusPlusPeripheral {
    private ITurtleAccess turtle;
    private ForgeChunkManager.Ticket ticket;
    private boolean attached = false;
    private ChunkPos pos;

    public PeripheralChunkLoader(ITurtleAccess turtle) {
        this.turtle = turtle;
        this.pos = new ChunkPos(turtle.getPosition());
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.attached = true;
    }

    public void update() {
        if (this.attached && !this.turtle.getWorld().field_72995_K && (this.ticket == null || this.posChanged())) {
            this.pos = new ChunkPos(this.turtle.getPosition());
            this.updateTicket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(IComputerAccess computer) {
        PeripheralChunkLoader peripheralChunkLoader = this;
        synchronized (peripheralChunkLoader) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = null;
    }

    public void updateTicket() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        this.ticket = ForgeChunkManager.requestTicket((Object)PeripheralsPlusPlus.instance, (World)this.turtle.getWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        for (ChunkPos coordIntPair : this.getChunksInRadius(Config.chunkLoadingRadius)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)coordIntPair);
        }
    }

    public ArrayList<ChunkPos> getChunksInRadius(int radius) {
        ArrayList<ChunkPos> chunkList = new ArrayList<ChunkPos>();
        for (int chunkX = this.pos.field_77276_a - radius; chunkX <= this.pos.field_77276_a + radius; ++chunkX) {
            for (int chunkZ = this.pos.field_77275_b - radius; chunkZ <= this.pos.field_77275_b + radius; ++chunkZ) {
                chunkList.add(new ChunkPos(chunkX, chunkZ));
            }
        }
        return chunkList;
    }

    public boolean posChanged() {
        return !new ChunkPos(this.turtle.getPosition()).equals((Object)this.pos);
    }

    public String getType() {
        return "chunkLoader";
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public static class LoaderHandler
    implements ForgeChunkManager.LoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        }
    }
}

