/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.tiles.NetworkedTileEntity;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityRFCharger
extends NetworkedTileEntity
implements IEnergyStorage,
ITickable {
    private EnergyStorage storage = new EnergyStorage(80000);

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("capacity")) {
            int capacity = nbttagcompound.func_74762_e("capacity");
            int energy = nbttagcompound.func_74762_e("energy");
            this.storage = new EnergyStorage(capacity, capacity, capacity, energy);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("capacity", this.storage.getMaxEnergyStored());
        nbttagcompound.func_74768_a("energy", this.storage.getEnergyStored());
        return nbttagcompound;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            ArrayList<ITurtleAccess> turtles = new ArrayList<ITurtleAccess>(6);
            for (EnumFacing direction : EnumFacing.values()) {
                TileEntity te;
                BlockPos pos = this.func_174877_v().func_177972_a(direction);
                if (this.func_145831_w().func_175623_d(pos) || (te = this.func_145831_w().func_175625_s(pos)) == null) continue;
                try {
                    ITurtleAccess turtle = ReflectionHelper.getTurtle(te);
                    if (turtle == null) continue;
                    turtles.add(turtle);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int rate = (int)Math.floor(6.0f / (float)turtles.size());
            for (ITurtleAccess turtle : turtles) {
                if (this.storage.getEnergyStored() < rate) continue;
                this.storage.extractEnergy(this.addFuel(turtle, rate) * Config.fuelRF, false);
            }
        }
    }

    private int addFuel(ITurtleAccess turtle, int rate) {
        if (turtle.getFuelLimit() > turtle.getFuelLevel()) {
            turtle.setFuelLevel(rate + turtle.getFuelLevel());
            return rate;
        }
        return 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.storage.canExtract();
    }

    public boolean canReceive() {
        return this.storage.canReceive();
    }

    public void showFuel(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("Energy: %d/%dRF", this.getEnergyStored(), this.getMaxEnergyStored())));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability.equals((Object)CapabilityEnergy.ENERGY) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

