/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.ChatUtil;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityOreDictionary
extends TileEntity
implements IPlusPlusPeripheral {
    private HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private ITurtleAccess turtle = null;

    public TileEntityOreDictionary() {
    }

    public TileEntityOreDictionary(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    public String getType() {
        return "oreDictionary";
    }

    private boolean isTurtle() {
        return this.turtle != null;
    }

    public String[] getMethodNames() {
        if (this.isTurtle()) {
            return new String[]{"getEntries", "combineStacks", "transmute", "doItemsMatch"};
        }
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableOreDictionary) {
            throw new LuaException("Ore Dictionaries have been disabled");
        }
        try {
            if (method == 0) {
                ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
                if (slot.func_190926_b()) {
                    throw new LuaException("Empty slot");
                }
                return new Object[]{Util.getOreDictEntries(slot)};
            }
            if (method == 1) {
                int argSlot2;
                if (arguments.length <= 0 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (arguments.length <= 1 || !(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                int argSlot1 = (int)((Double)arguments[0]).doubleValue() - 1;
                if (argSlot1 == (argSlot2 = (int)((Double)arguments[1]).doubleValue() - 1)) {
                    return new Object[]{true};
                }
                ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()).func_77946_l();
                ItemStack stack1 = this.turtle.getInventory().func_70301_a(argSlot1).func_77946_l();
                ItemStack stack2 = this.turtle.getInventory().func_70301_a(argSlot2).func_77946_l();
                if (stack1.func_190926_b() || stack2.func_190926_b()) {
                    throw new LuaException("One or more selected slots have nil items");
                }
                if (!Util.compareItemStacksViaOreDict(stack1, stack2)) {
                    throw new LuaException("Stacks are not equivalent");
                }
                if (!Util.compareItemStacksViaOreDict(stack1, slot) && !slot.func_190926_b()) {
                    throw new LuaException("The destination slot is incompatible");
                }
                if (argSlot1 == this.turtle.getSelectedSlot()) {
                    this.combineSlots(this.turtle.getSelectedSlot(), argSlot2);
                    return new Object[]{true};
                }
                if (argSlot2 == this.turtle.getSelectedSlot()) {
                    this.combineSlots(this.turtle.getSelectedSlot(), argSlot1);
                } else {
                    this.combineSlots(this.turtle.getSelectedSlot(), argSlot1);
                    this.combineSlots(argSlot1, argSlot2);
                    this.combineSlots(this.turtle.getSelectedSlot(), argSlot1);
                }
                return new Object[]{true};
            }
            if (method == 2) {
                ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()).func_77946_l();
                if (slot.func_190926_b()) {
                    throw new LuaException("Selected slot's item is nil");
                }
                ItemStack newStack = this.transmute(slot);
                if (newStack.func_190926_b() || newStack.func_77969_a(slot)) {
                    return new Object[]{false};
                }
                newStack.func_190920_e(slot.func_190916_E());
                this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), newStack);
                return new Object[]{true};
            }
            if (method == 3) {
                if (arguments.length <= 0 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (arguments.length <= 1 || !(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                double arg1 = (Double)arguments[0];
                double arg2 = (Double)arguments[1];
                return new Object[]{Util.compareItemStacksViaOreDict(this.turtle.getInventory().func_70301_a((int)(arg1 -= 1.0)), this.turtle.getInventory().func_70301_a((int)(arg2 -= 1.0)))};
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Object[0];
    }

    private void combineSlots(int outputSlotNum, int fillerSlotNum) {
        ItemStack output = this.turtle.getInventory().func_70301_a(outputSlotNum);
        ItemStack filler = this.turtle.getInventory().func_70301_a(fillerSlotNum);
        int freeAmount = output.func_77976_d() - output.func_190916_E();
        if (output.func_190926_b()) {
            output = filler.func_77946_l();
            output.func_190920_e(0);
        }
        if (filler.func_190916_E() > freeAmount) {
            output.func_190920_e(output.func_190916_E() + freeAmount);
            filler.func_190920_e(filler.func_190916_E() - freeAmount);
        } else {
            output.func_190920_e(output.func_190916_E() + filler.func_190916_E());
            filler.func_190920_e(0);
        }
        this.turtle.getInventory().func_70299_a(outputSlotNum, output);
        this.turtle.getInventory().func_70299_a(fillerSlotNum, filler);
    }

    @Override
    public void attach(IComputerAccess computer) {
        if (!this.isTurtle()) {
            this.computers.put(computer, true);
        }
    }

    @Override
    public void detach(IComputerAccess computer) {
        if (!this.isTurtle()) {
            this.computers.remove(computer);
        }
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    private ItemStack transmute(ItemStack item) {
        HashMap<Integer, String> oreDictEntries = Util.getOreDictEntries(item);
        boolean returnNextItem = false;
        for (String oreDictName : oreDictEntries.values()) {
            NonNullList otherDictEntries = OreDictionary.getOres((String)oreDictName);
            for (ItemStack stack : otherDictEntries) {
                if (returnNextItem) {
                    return stack.func_77946_l();
                }
                if (!stack.func_77969_a(item)) continue;
                returnNextItem = true;
            }
            if (!returnNextItem) continue;
            return ((ItemStack)otherDictEntries.get(0)).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public boolean blockActivated(EntityPlayer player) {
        if (!player.func_184614_ca().func_190926_b()) {
            for (IComputerAccess computer : this.computers.keySet()) {
                computer.queueEvent("oreDict", new Object[]{Util.getOreDictEntries(player.func_184614_ca())});
            }
            if (Config.oreDictionaryMessage) {
                ChatUtil.sendMessage(player.getDisplayNameString(), this, Util.getOreDictEntries(player.func_184614_ca()).entrySet().toString(), 100.0, true);
            }
            return true;
        }
        return false;
    }
}

