/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.cleverbot.AIChatRequest;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.michaelwflaherty.cleverbotapi.CleverBotQuery;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;

public class TileEntityAIChatBox
extends TileEntity
implements IPlusPlusPeripheral {
    private List<BotSessionLuaObject> sessions = new ArrayList<BotSessionLuaObject>();
    private List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    public String getType() {
        return "aiChatBox";
    }

    public String[] getMethodNames() {
        return new String[]{"newSession", "getSession", "getAllSessions"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableAIChatBox) {
            throw new LuaException("AI Chat Boxes have been disabled");
        }
        if (this.func_145837_r()) {
            throw new LuaException("ERROR invalid tile entity");
        }
        if (method == 0) {
            String apiKey = Config.cleverbotApiKey;
            if (arguments.length == 1) {
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("First object is expected to be an API key string");
                }
                apiKey = (String)arguments[0];
            }
            if (apiKey.isEmpty()) {
                throw new LuaException("No API key registered in the mod config or passed as an argument");
            }
            return Methods.newSession(computer, context, this, apiKey);
        }
        if (method == 1) {
            UUID uuid = ArgumentHelper.getUUID(arguments, 0);
            return Methods.getSession(computer, context, this, uuid);
        }
        if (method == 2) {
            return Methods.getAllSessions(computer, context, this);
        }
        return new Object[0];
    }

    public void sendEvent(Object[] params) {
        ArrayList<Object> arguments = new ArrayList<Object>(Arrays.asList(params));
        arguments.add(0, "SIDE");
        for (IComputerAccess computer : this.computers) {
            arguments.set(0, computer.getAttachmentName());
            computer.queueEvent("ai_response", arguments.toArray());
        }
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public List<BotSessionLuaObject> getSessions() {
        return this.sessions;
    }

    public static class BotSessionLuaObject
    implements ILuaObject {
        private final UUID uuid;
        private final CleverBotQuery session;
        private final IComputerAccess computer;
        private final TileEntityAIChatBox source;
        private boolean removed = false;

        public BotSessionLuaObject(UUID uuid, CleverBotQuery session, IComputerAccess computer, TileEntityAIChatBox source) {
            this.uuid = uuid;
            this.session = session;
            this.computer = computer;
            this.source = source;
        }

        public String[] getMethodNames() {
            return new String[]{"think", "thinkAsync", "getUUID", "remove"};
        }

        public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            if (this.removed) {
                throw new LuaException("ERROR accessing removed session!");
            }
            if (this.source.func_145837_r()) {
                throw new LuaException("ERROR invalid tile entity!");
            }
            if (method == 0) {
                String message = ArgumentHelper.getString(arguments, 0);
                this.thinkAsync(message);
                Object[] event = context.pullEvent("ai_response");
                while (!this.uuid.toString().equals(event[4])) {
                    event = context.pullEvent("ai_response");
                }
                return new Object[]{event[2], event[3]};
            }
            if (method == 1) {
                String message = ArgumentHelper.getString(arguments, 0);
                this.thinkAsync(message);
            }
            if (method == 2) {
                return new Object[]{this.getUUID().toString()};
            }
            if (method == 3) {
                this.removed = true;
                return new Object[]{this.source.getSessions().remove(this)};
            }
            return new Object[0];
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public void thinkAsync(String message) throws LuaException, InterruptedException {
            AIChatRequest request = new AIChatRequest(this.source, this, message);
        }

        public String think(String message) throws Exception {
            this.session.setPhrase(message);
            this.session.sendRequest();
            return this.session.getResponse();
        }

        public static boolean containsUUID(List<BotSessionLuaObject> list, UUID uuid) {
            for (BotSessionLuaObject botSession : list) {
                if (botSession.getUUID() != uuid) continue;
                return true;
            }
            return false;
        }
    }

    public static class ArgumentHelper {
        public static UUID getUUID(Object[] arguments, int index) throws LuaException, InterruptedException {
            return ArgumentHelper.getUUID(arguments, index, null);
        }

        public static UUID getUUID(Object[] arguments, int index, UUID defaultValue) throws LuaException, InterruptedException {
            return ArgumentHelper.stringToUUID(ArgumentHelper.getString(arguments, index, defaultValue == null ? null : defaultValue.toString()));
        }

        public static String getString(Object[] arguments, int index) throws LuaException, InterruptedException {
            return ArgumentHelper.getString(arguments, index, null);
        }

        public static String getString(Object[] arguments, int index, String defaultValue) throws LuaException, InterruptedException {
            if (arguments == null || arguments.length <= index) {
                if (defaultValue == null) {
                    ArgumentHelper.ErrorOut(index, "string", "nil");
                } else {
                    return defaultValue;
                }
            }
            if (!(arguments[index] instanceof String)) {
                if (defaultValue == null) {
                    ArgumentHelper.ErrorOut(index, "string");
                } else {
                    return defaultValue;
                }
            }
            return (String)arguments[index];
        }

        static void ErrorOut(int index, String expected) throws LuaException, InterruptedException {
            throw new LuaException("Bad argument #" + (index + 1) + " (" + expected + " expected)");
        }

        static void ErrorOut(int index, String expected, String got) throws LuaException, InterruptedException {
            throw new LuaException("Bad argument #" + (index + 1) + " (" + expected + " expected, got " + got + ")");
        }

        public static UUID randomUUID(List<BotSessionLuaObject> existing) {
            UUID uuid = UUID.randomUUID();
            while (BotSessionLuaObject.containsUUID(existing, uuid)) {
                uuid = UUID.randomUUID();
            }
            return uuid;
        }

        static UUID stringToUUID(String string) throws LuaException, InterruptedException {
            if (string == null) {
                return null;
            }
            return UUID.fromString(string);
        }
    }

    public static class Methods {
        public static Object[] newSession(IComputerAccess computer, ILuaContext context, TileEntityAIChatBox tileEntity, String apiKey) throws LuaException, InterruptedException {
            List<BotSessionLuaObject> sessions = tileEntity.getSessions();
            try {
                UUID uuid = ArgumentHelper.randomUUID(sessions);
                CleverBotQuery botSession = new CleverBotQuery(apiKey, "");
                BotSessionLuaObject luaSession = new BotSessionLuaObject(uuid, botSession, computer, tileEntity);
                sessions.add(luaSession);
                return new Object[]{luaSession};
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new LuaException("ERROR creating session, make sure the server has internet access!");
            }
        }

        public static Object[] getSession(IComputerAccess computer, ILuaContext context, TileEntityAIChatBox tileEntity, UUID uuid) throws LuaException, InterruptedException {
            for (BotSessionLuaObject session : tileEntity.getSessions()) {
                if (!session.getUUID().equals(uuid)) continue;
                return new Object[]{session};
            }
            return new Object[0];
        }

        public static Object[] getAllSessions(IComputerAccess computer, ILuaContext context, TileEntityAIChatBox tileEntity) throws LuaException, InterruptedException {
            HashMap<String, BotSessionLuaObject> table = new HashMap<String, BotSessionLuaObject>();
            for (BotSessionLuaObject sessionLuaObject : tileEntity.getSessions()) {
                table.put(sessionLuaObject.getUUID().toString(), sessionLuaObject);
            }
            return new Object[]{table};
        }
    }
}

