/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.smarthelmet;

import com.austinv11.peripheralsplusplus.smarthelmet.HelmetCommand;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class DrawTextureCommand
extends HelmetCommand {
    public ResourceLocation resource;
    public int x;
    public int y;
    public int u;
    public int v;
    public int width;
    public int height;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void call(Gui gui) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemType type = this.isItemLocation();
        if (this.u == -1) {
            this.u = 0;
        }
        if (this.v == -1) {
            this.v = 0;
        }
        if (type.equals((Object)ItemType.NONE)) {
            GL11.glEnable((int)3042);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resource);
            gui.func_73729_b(this.x, this.y, this.u, this.v, this.width, this.height);
            GL11.glDisable((int)3042);
        } else {
            ItemStack toRender = null;
            switch (type) {
                case ITEM: {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(this.resource);
                    if (item == null) {
                        return;
                    }
                    toRender = new ItemStack(item);
                    break;
                }
                case BLOCK: {
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.resource);
                    if (block == null) {
                        return;
                    }
                    toRender = new ItemStack(block);
                }
            }
            if (toRender != null) {
                Minecraft.func_71410_x().func_175599_af().func_175042_a(toRender, this.x, this.y);
            }
        }
    }

    @Override
    public String getCommandName() {
        return "DrawTextureCommand";
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.resource = new ResourceLocation(tagCompound.func_74779_i("resource"));
        this.x = tagCompound.func_74762_e("x");
        this.y = tagCompound.func_74762_e("y");
        this.u = tagCompound.func_74762_e("u");
        this.v = tagCompound.func_74762_e("v");
        this.width = tagCompound.func_74762_e("width");
        this.height = tagCompound.func_74762_e("height");
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("resource", this.resource.toString());
        tagCompound.func_74768_a("x", this.x);
        tagCompound.func_74768_a("y", this.y);
        tagCompound.func_74768_a("u", this.u);
        tagCompound.func_74768_a("v", this.v);
        tagCompound.func_74768_a("width", this.width);
        tagCompound.func_74768_a("height", this.height);
    }

    private ItemType isItemLocation() {
        if (ForgeRegistries.BLOCKS.getValue(this.resource) != Blocks.field_150350_a) {
            return ItemType.BLOCK;
        }
        if (ForgeRegistries.ITEMS.getValue(this.resource) != Items.field_190931_a) {
            return ItemType.ITEM;
        }
        return ItemType.NONE;
    }

    private static enum ItemType {
        ITEM,
        BLOCK,
        NONE;

    }
}

