/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.recipe;

import com.austinv11.collectiveframework.minecraft.utils.Colors;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftRegistry;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.TurtleUtil;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeContainerPocket
implements IRecipe {
    private final ResourceLocation group;
    private ResourceLocation name;

    public RecipeContainerPocket(ResourceLocation group) {
        this.group = group;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack container = this.getPeripheralContainer(inv);
        if (container.func_190926_b()) {
            return false;
        }
        List<IPocketUpgrade> peripherals = this.getPeripherals(inv);
        if (peripherals.size() == 0) {
            return false;
        }
        int items = 0;
        for (int itemStack = 0; itemStack < inv.func_70302_i_(); ++itemStack) {
            if (inv.func_70301_a(itemStack).func_190926_b()) continue;
            ++items;
        }
        if (items != peripherals.size() + 1) {
            return false;
        }
        NBTTagList contained = this.getContainedPeripherals(container);
        for (int containedIndex = 0; containedIndex < contained.func_74745_c(); ++containedIndex) {
            String name = contained.func_150307_f(containedIndex);
            for (IPocketUpgrade upgrade : peripherals) {
                if (!name.equals(upgrade.getUpgradeID().toString())) continue;
                return false;
            }
        }
        return contained.func_74745_c() + peripherals.size() <= Config.maxNumberOfPeripherals;
    }

    private NBTTagList getContainedPeripherals(ItemStack container) {
        NBTTagList tagList = new NBTTagList();
        if (container.func_77978_p() != null && container.func_77978_p().func_74764_b("peripheralsplusone:pocket_container")) {
            NBTBase idTag = container.func_77978_p().func_74781_a("peripheralsplusone:pocket_container");
            if (!(idTag instanceof NBTTagList)) {
                return tagList;
            }
            return (NBTTagList)idTag;
        }
        return tagList;
    }

    private List<IPocketUpgrade> getPeripherals(InventoryCrafting inventory) {
        ArrayList<IPocketUpgrade> peripherals = new ArrayList<IPocketUpgrade>();
        for (int itemIndex = 0; itemIndex < inventory.func_70302_i_(); ++itemIndex) {
            ItemStack itemStack = inventory.func_70301_a(itemIndex).func_77946_l();
            if (itemStack.func_190916_E() != 1) continue;
            for (IPocketUpgrade pocketUpgrade : ComputerCraftRegistry.getPocketUpgrades().values()) {
                if (!pocketUpgrade.getCraftingItem().func_77969_a(itemStack) || pocketUpgrade.getCraftingItem().func_77969_a(new ItemStack((Block)ModBlocks.PERIPHERAL_CONTAINER)) || peripherals.contains(pocketUpgrade)) continue;
                peripherals.add(pocketUpgrade);
            }
        }
        return peripherals;
    }

    private ItemStack getPeripheralContainer(InventoryCrafting inventory) {
        ItemStack returnStack = ItemStack.field_190927_a;
        ItemStack pocket = TurtleUtil.getPocket(true);
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack itemStack = inventory.func_70301_a(slot).func_77946_l();
            if (pocket.func_77973_b() != itemStack.func_77973_b()) continue;
            if (itemStack.func_190916_E() != 1 || !returnStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound == null || !tagCompound.func_74779_i("upgrade").equals("peripheralsplusone:pocket_container")) continue;
            returnStack = itemStack.func_77946_l();
        }
        return returnStack;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack container = this.getPeripheralContainer(inv);
        List<IPocketUpgrade> peripherals = this.getPeripherals(inv);
        NBTTagList contained = this.getContainedPeripherals(container);
        ArrayList<String> text = new ArrayList<String>();
        if (contained.func_74745_c() == 0) {
            text.add(Colors.RESET.toString() + Colors.UNDERLINE + "Contained Peripherals:");
        }
        for (IPocketUpgrade peripheral : peripherals) {
            contained.func_74742_a((NBTBase)new NBTTagString(peripheral.getUpgradeID().toString()));
            text.add(Colors.RESET + peripheral.getUpgradeID().toString());
        }
        NBTHelper.setTag((ItemStack)container, (String)"peripheralsplusone:pocket_container", (NBTBase)contained);
        NBTHelper.addInfo((ItemStack)container, text);
        return container;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return TurtleUtil.getPocket(true);
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public String func_193358_e() {
        return this.group.toString();
    }
}

