/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.pocket.peripherals;

import com.austinv11.peripheralsplusplus.lua.LuaObjectPeripheralWrap;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PeripheralPeripheralContainer
implements IPlusPlusPeripheral {
    private final Map<IPocketUpgrade, IPeripheral> pocketUpgrades;
    private Map<ResourceLocation, ItemStack> unequippedItems;

    public PeripheralPeripheralContainer(Map<IPocketUpgrade, IPeripheral> pocketUpgrades) {
        this.pocketUpgrades = pocketUpgrades;
        this.unequippedItems = new HashMap<ResourceLocation, ItemStack>();
    }

    public String getType() {
        return "peripheralContainer";
    }

    public String[] getMethodNames() {
        return new String[]{"getContainedPeripherals", "wrapPeripheral", "unequipPeripheral"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enablePeripheralContainer) {
            throw new LuaException("Peripheral Containers have been disabled");
        }
        if (method == 0) {
            HashMap<Integer, String> returnVals = new HashMap<Integer, String>();
            for (int i = 0; i < this.getPeripherals().size(); ++i) {
                returnVals.put(i + 1, this.getPeripherals().get(i).getType());
            }
            return new Object[]{returnVals};
        }
        if (method == 1) {
            if (arguments.length < 1) {
                throw new LuaException("Too few arguments");
            }
            if (!(arguments[0] instanceof String)) {
                throw new LuaException("Bad argument #1 (expected string)");
            }
            return new Object[]{new LuaObjectPeripheralWrap(this.getPeripheralByName((String)arguments[0]), computer)};
        }
        if (method == 2) {
            if (arguments.length < 1) {
                throw new LuaException("Usage: unequip <String peripheral type>");
            }
            if (!(arguments[0] instanceof String)) {
                throw new LuaException("First argument expected to be a string");
            }
            IPeripheral peripheral = this.getPeripheralByName((String)arguments[0]);
            if (peripheral == null) {
                return new Object[]{false};
            }
            HashMap<ResourceLocation, ItemStack> unequipped = new HashMap<ResourceLocation, ItemStack>();
            for (Map.Entry<IPocketUpgrade, IPeripheral> upgrade : this.getUpgrades().entrySet()) {
                if (!upgrade.getValue().equals(peripheral)) continue;
                unequipped.put(upgrade.getKey().getUpgradeID(), upgrade.getKey().getCraftingItem());
                this.getUpgrades().remove(upgrade.getKey(), upgrade.getValue());
                break;
            }
            if (unequipped.isEmpty()) {
                return new Object[]{false};
            }
            this.unequippedItems.putAll(unequipped);
            return new Object[]{true};
        }
        return new Object[0];
    }

    private IPeripheral getPeripheralByName(String argument) {
        for (IPeripheral peripheral : this.getPeripherals()) {
            if (!peripheral.getType().equals(argument)) continue;
            return peripheral;
        }
        return null;
    }

    private List<IPeripheral> getPeripherals() {
        ArrayList<IPeripheral> peripherals = new ArrayList<IPeripheral>();
        peripherals.addAll(this.pocketUpgrades.values());
        return peripherals;
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    @Override
    public void attach(IComputerAccess computer) {
        for (IPeripheral peripheral : this.getPeripherals()) {
            peripheral.attach(computer);
        }
    }

    @Override
    public void detach(IComputerAccess computer) {
        for (IPeripheral peripheral : this.getPeripherals()) {
            peripheral.detach(computer);
        }
    }

    public Map<IPocketUpgrade, IPeripheral> getUpgrades() {
        return this.pocketUpgrades;
    }

    public Map<ResourceLocation, ItemStack> getUnequippedItems() {
        return this.unequippedItems;
    }
}

