/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.mount;

import dan200.computercraft.api.filesystem.IWritableMount;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;

public class DynamicMountWritable
implements IWritableMount {
    private final File directory;
    private static final long MAX_SIZE = 102400L;

    DynamicMountWritable(File directory) {
        this.directory = directory;
    }

    private File getFile(String path) {
        return new File(this.directory, path);
    }

    public void makeDirectory(@Nonnull String path) throws IOException {
        File file = this.getFile(path);
        file.mkdir();
    }

    public void delete(@Nonnull String path) throws IOException {
        File file = this.getFile(path);
        file.delete();
    }

    @Nonnull
    public OutputStream openForWrite(@Nonnull String path) throws IOException {
        return new FileOutputStream(this.getFile(path));
    }

    @Nonnull
    public OutputStream openForAppend(@Nonnull String path) throws IOException {
        return new FileOutputStream(this.getFile(path), true);
    }

    public long getRemainingSpace() throws IOException {
        return 102400L - FileUtils.sizeOfDirectory((File)this.directory);
    }

    public boolean exists(@Nonnull String path) throws IOException {
        return this.getFile(path).exists();
    }

    public boolean isDirectory(@Nonnull String path) throws IOException {
        return this.getFile(path).isDirectory();
    }

    public void list(@Nonnull String path, @Nonnull List<String> contents) throws IOException {
        File startPath = this.getFile(path);
        if (startPath.isFile()) {
            throw new IOException(path);
        }
        String[] list = startPath.list();
        if (list != null) {
            contents.addAll(Arrays.asList(list));
        }
    }

    public long getSize(@Nonnull String path) throws IOException {
        return this.getFile(path).getTotalSpace();
    }

    @Nonnull
    public InputStream openForRead(@Nonnull String path) throws IOException {
        return new FileInputStream(this.getFile(path));
    }
}

