/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.mount;

import com.austinv11.peripheralsplusplus.mount.DynamicMount;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import com.austinv11.peripheralsplusplus.utils.proxy.PeripheralChangeListener;
import com.austinv11.peripheralsplusplus.utils.proxy.Task;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.reflect.InvocationTargetException;

public class DynamicMountPeripheralChangeListener
extends PeripheralChangeListener {
    private final Object peripheralChangeListener;
    private final Object computer;

    public DynamicMountPeripheralChangeListener(Object computer, Object peripheralChangeListener) {
        this.computer = computer;
        this.peripheralChangeListener = peripheralChangeListener;
    }

    @Override
    public void onPeripheralChanged(int side, final IPeripheral newPeripheral) {
        try {
            ReflectionHelper.onPeripheralChanged(side, newPeripheral, this.peripheralChangeListener);
            final Object wrappedPeripheral = ReflectionHelper.getPeripheralWrapperFromChangeListener(this.peripheralChangeListener, side);
            if (newPeripheral != null && wrappedPeripheral != null) {
                ReflectionHelper.queueTask(new Task(){

                    @Override
                    public Object getOwner() {
                        return DynamicMountPeripheralChangeListener.this.computer;
                    }

                    @Override
                    public void execute() {
                        DynamicMount.attach((IComputerAccess)wrappedPeripheral, newPeripheral);
                    }
                }, null);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean initializePeripherals() {
        for (int side = 0; side < 6; ++side) {
            try {
                Object wrappedPeripheral = ReflectionHelper.getPeripheralWrapperFromChangeListener(this.peripheralChangeListener, side);
                if (wrappedPeripheral == null) continue;
                if (!ReflectionHelper.isWrappedPeripheralAttached(wrappedPeripheral)) {
                    return false;
                }
                IPeripheral peripheral = ReflectionHelper.getPeripheral(this.computer, side);
                if (peripheral == null) continue;
                this.onPeripheralChanged(side, peripheral);
                continue;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

