/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.lua;

import com.austinv11.collectiveframework.minecraft.utils.Location;
import com.austinv11.collectiveframework.minecraft.utils.WorldUtils;
import com.austinv11.collectiveframework.utils.math.MathUtils;
import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.capabilities.nano.CapabilityNanoBot;
import com.austinv11.peripheralsplusplus.capabilities.nano.NanoBotHolder;
import com.austinv11.peripheralsplusplus.items.ItemNanoSwarm;
import com.austinv11.peripheralsplusplus.network.RobotEventPacket;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LuaObjectEntityControl
implements ILuaObject {
    private UUID id;
    private boolean isPlayer;
    private EntityPlayer player;
    private EntityLiving entity;

    public LuaObjectEntityControl(UUID id, Entity entity) {
        this.id = id;
        if (entity instanceof EntityPlayer) {
            this.isPlayer = true;
            this.player = (EntityPlayer)entity;
        } else {
            this.isPlayer = false;
            this.entity = (EntityLiving)entity;
        }
    }

    public String[] getMethodNames() {
        if (this.isPlayer) {
            return new String[]{"isPlayer", "hurt", "heal", "getHealth", "getMaxHealth", "isDead", "getRemainingBots", "getDisplayName", "getPlayerName", "getUUID", "getHunger", "click", "clickRelease", "keyPress", "keyRelease", "mouseMove", "whisper"};
        }
        return new String[]{"isPlayer", "hurt", "heal", "getHealth", "getMaxHealth", "isDead", "getRemainingBots", "getDisplayName", "getEntityName", "setTarget", "setAttackTarget", "setMovementTarget", "setTurnAngle", "toggleJumping"};
    }

    public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        EntityPlayer updatedPlayer;
        if (this.isPlayer && (updatedPlayer = Util.getPlayer(this.player.getPersistentID())) != null) {
            this.player = updatedPlayer;
        }
        if (method < 8) {
            switch (method) {
                case 0: {
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)(this.isPlayer ? this.player : this.entity), true, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    return new Object[]{this.isPlayer};
                }
                case 1: {
                    if (this.isPlayer) {
                        if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, false, 1)) {
                            return new Object[]{false};
                        }
                        this.player.func_70097_a(new DamageSource("peripheralsplusone".toLowerCase() + ".nanobot").func_76348_h(), 1.0f);
                        break;
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, false, 1)) {
                        return new Object[]{false};
                    }
                    this.entity.func_70097_a(new DamageSource("peripheralsplusone".toLowerCase() + ".nanobot").func_76348_h(), 1.0f);
                    break;
                }
                case 2: {
                    if (this.isPlayer) {
                        if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, false, 1)) {
                            return new Object[]{false};
                        }
                        this.player.func_70691_i(1.0f);
                        break;
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, false, 1)) {
                        return new Object[]{false};
                    }
                    this.entity.func_70691_i(1.0f);
                    break;
                }
                case 3: {
                    if (this.isPlayer) {
                        if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, true, 1)) {
                            throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                        }
                        return new Object[]{Float.valueOf(this.player.func_110143_aJ())};
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, true, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    return new Object[]{Float.valueOf(this.entity.func_110143_aJ())};
                }
                case 4: {
                    if (this.isPlayer) {
                        if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, true, 1)) {
                            throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                        }
                        return new Object[]{Float.valueOf(this.player.func_110138_aP())};
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, true, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    return new Object[]{Float.valueOf(this.entity.func_110138_aP())};
                }
                case 5: {
                    if (this.isPlayer) {
                        if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, true, 1)) {
                            throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                        }
                        return new Object[]{this.player.field_70128_L};
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, true, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    return new Object[]{this.entity.field_70128_L};
                }
                case 6: {
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)(this.isPlayer ? this.player : this.entity), true, 0)) {
                        throw new LuaException("Cannot get bots from entity");
                    }
                    if (this.isPlayer) {
                        return new Object[]{((NanoBotHolder)this.player.getCapability(CapabilityNanoBot.INSTANCE, null)).getBots()};
                    }
                    return new Object[]{((NanoBotHolder)this.entity.getCapability(CapabilityNanoBot.INSTANCE, null)).getBots()};
                }
                case 7: {
                    if (this.isPlayer) {
                        if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, true, 1)) {
                            throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                        }
                        return new Object[]{this.player.func_145748_c_().func_150254_d()};
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, true, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    return new Object[]{this.entity.func_95999_t()};
                }
            }
        } else if (this.isPlayer) {
            switch (method) {
                case 8: {
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, true, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    return new Object[]{this.player.func_146103_bH().getName()};
                }
                case 9: {
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, true, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    return new Object[]{this.player.func_146103_bH().getId().toString()};
                }
                case 10: {
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, true, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    return new Object[]{this.player.func_71024_bL().func_75116_a()};
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    Object object;
                    RobotEventPacket.ActionType action;
                    RobotEventPacket.PressType type;
                    if (arguments.length < 1 || method == 15 && arguments.length < 2) {
                        throw new LuaException("Too few arguments");
                    }
                    if (!(arguments[0] instanceof Double && method < 13 || arguments[0] instanceof String && method < 15 || arguments[0] instanceof Double && method == 15)) {
                        throw new LuaException("Bad argument #1 (expected string or number)");
                    }
                    if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                        throw new LuaException("Bad argument #2 (expected number)");
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, false, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    RobotEventPacket.PressType pressType = type = MathUtils.isEvenNumber((int)method) ? RobotEventPacket.PressType.RELEASE : RobotEventPacket.PressType.PRESS;
                    RobotEventPacket.ActionType actionType = method < 13 ? RobotEventPacket.ActionType.MOUSE_CLICK : (action = method < 15 ? RobotEventPacket.ActionType.KEYBOARD : RobotEventPacket.ActionType.MOUSE_MOVE);
                    if (arguments.length == 1 && arguments[0] instanceof Double) {
                        object = (int)((Double)arguments[0]).doubleValue();
                    } else if (arguments[0] instanceof String) {
                        object = (String)arguments[0];
                    } else {
                        int[] nArray = new int[2];
                        nArray[0] = (int)((Double)arguments[0]).doubleValue();
                        object = nArray;
                        nArray[1] = (int)((Double)arguments[1]).doubleValue();
                    }
                    String args = object;
                    PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new RobotEventPacket(action, type, args), (EntityPlayerMP)this.player);
                    break;
                }
                case 16: {
                    if (arguments.length < 1) {
                        throw new LuaException("Too few arguments");
                    }
                    if (!(arguments[0] instanceof String)) {
                        throw new LuaException("Bad argument #1 (expected string)");
                    }
                    if (arguments.length > 1 && !(arguments[1] instanceof String)) {
                        throw new LuaException("Bad argument #2 (expected string)");
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.player, false, 1)) {
                        return new Object[]{false};
                    }
                    String sender = arguments.length > 1 ? "<" + arguments[1] + "> " : "";
                    this.player.func_145747_a((ITextComponent)new TextComponentString(sender + arguments[0]));
                }
            }
        } else {
            switch (method) {
                case 8: {
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, true, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    return new Object[]{this.entity.getClass().getSimpleName()};
                }
                case 9: {
                    if (arguments.length < 1) {
                        throw new LuaException("Too few arguments");
                    }
                    if (!(arguments[0] instanceof String) && !(arguments[0] instanceof Double)) {
                        throw new LuaException("Bad argument #1 (expected string or number)");
                    }
                    if (arguments[0] instanceof Double && (arguments.length <= 1 || !(arguments[1] instanceof Double))) {
                        throw new LuaException("Bad argument #2 (expected number)");
                    }
                    if (arguments[0] instanceof Double && (arguments.length <= 2 || !(arguments[2] instanceof Double))) {
                        throw new LuaException("Bad argument #3 (expected number)");
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, false, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    Object target = arguments[0] instanceof String ? WorldUtils.getPlayerForWorld((String)((String)arguments[0]), (World)this.entity.field_70170_p) : WorldUtils.getNearestEntityToLocation((Location)new Location(((Double)arguments[0]).doubleValue(), ((Double)arguments[1]).doubleValue(), ((Double)arguments[2]).doubleValue(), this.entity.field_70170_p));
                    if (!(target instanceof EntityLivingBase)) {
                        throw new LuaException("Target must be living");
                    }
                    this.entity.func_70624_b((EntityLivingBase)target);
                    return new Object[]{true};
                }
                case 10: {
                    if (arguments.length < 1) {
                        throw new LuaException("Too few arguments");
                    }
                    if (!(arguments[0] instanceof String) && !(arguments[0] instanceof Double)) {
                        throw new LuaException("Bad argument #1 (expected string or number)");
                    }
                    if (arguments[0] instanceof Double && (arguments.length <= 1 || !(arguments[1] instanceof Double))) {
                        throw new LuaException("Bad argument #2 (expected number)");
                    }
                    if (arguments[0] instanceof Double && (arguments.length <= 2 || !(arguments[2] instanceof Double))) {
                        throw new LuaException("Bad argument #3 (expected number)");
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, false, 1)) {
                        throw new LuaException("Entity with id " + this.id + " cannot be interacted with");
                    }
                    Object attackTarget = arguments[0] instanceof String ? WorldUtils.getPlayerForWorld((String)((String)arguments[0]), (World)this.entity.field_70170_p) : WorldUtils.getNearestEntityToLocation((Location)new Location(((Double)arguments[0]).doubleValue(), ((Double)arguments[1]).doubleValue(), ((Double)arguments[2]).doubleValue(), this.entity.field_70170_p));
                    this.entity.func_70624_b((EntityLivingBase)attackTarget);
                    return new Object[]{attackTarget != null};
                }
                case 11: {
                    if (arguments.length < 3) {
                        throw new LuaException("Too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new LuaException("Bad argument #1 (expected number)");
                    }
                    if (!(arguments[1] instanceof Double)) {
                        throw new LuaException("Bad argument #2 (expected number)");
                    }
                    if (!(arguments[2] instanceof Double)) {
                        throw new LuaException("Bad argument #3 (expected number)");
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, false, 1)) {
                        return new Object[]{false};
                    }
                    this.entity.func_70661_as().func_75484_a(this.entity.func_70661_as().func_75488_a(((Double)arguments[0]).doubleValue(), ((Double)arguments[1]).doubleValue(), ((Double)arguments[2]).doubleValue()), (double)this.entity.func_70689_ay());
                    break;
                }
                case 12: {
                    if (arguments.length < 1) {
                        throw new LuaException("Too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new LuaException("Bad argument #1 (expected number)");
                    }
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, false, 1)) {
                        return new Object[]{false};
                    }
                    this.entity.field_70177_z = (float)((Double)arguments[0]).doubleValue();
                    this.entity.field_70759_as = (float)((Double)arguments[0]).doubleValue();
                    break;
                }
                case 13: {
                    if (!ItemNanoSwarm.doInstruction(this.id, (Entity)this.entity, false, 1)) {
                        return new Object[]{false};
                    }
                    this.entity.func_70637_d(!this.entity.field_70703_bu);
                }
            }
        }
        return new Object[]{true};
    }
}

