/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.inventory.ComparableItemStackSafe;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.api.crafting.recipes.IChargerRecipe;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ChargerManager {
    private static Map<ComparableItemStackSafe, RecipeCharger> recipeMap = new THashMap();
    private static boolean allowOverwrite = false;
    public static final int DEFAULT_ENERGY = 4000;

    public static RecipeCharger getRecipe(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ComparableItemStackSafe comparableItemStackSafe = new ComparableItemStackSafe(itemStack);
        RecipeCharger recipeCharger = recipeMap.get(itemStack);
        if (recipeCharger == null) {
            comparableItemStackSafe.metadata = Short.MAX_VALUE;
            recipeCharger = recipeMap.get(comparableItemStackSafe);
        }
        return recipeCharger;
    }

    public static boolean recipeExists(ItemStack itemStack) {
        return ChargerManager.getRecipe(itemStack) != null;
    }

    public static RecipeCharger[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeCharger[0]);
    }

    public static void addDefaultRecipes() {
    }

    public static void loadRecipes() {
        if (ItemHelper.oreNameExists((String)"crystalCertusQuartz") && ItemHelper.oreNameExists((String)"crystalCertusQuartzCharged")) {
            ChargerManager.addRecipe(3200, (ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz").get(0), (ItemStack)OreDictionary.getOres((String)"crystalCertusQuartzCharged").get(0));
        }
    }

    public static void refreshRecipes() {
        THashMap tHashMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackSafe, RecipeCharger> entry : recipeMap.entrySet()) {
            RecipeCharger recipeCharger = entry.getValue();
            tHashMap.put(new ComparableItemStackSafe(recipeCharger.input), recipeCharger);
        }
        recipeMap.clear();
        recipeMap = tHashMap;
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null || n <= 0) {
            return false;
        }
        RecipeCharger recipeCharger = new RecipeCharger(itemStack, itemStack2, n);
        recipeMap.put(new ComparableItemStackSafe(itemStack), recipeCharger);
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        return ChargerManager.addRecipe(n, itemStack, itemStack2, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        if (itemStack == null || itemStack2 == null || n <= 0 || !(allowOverwrite & bl) && recipeMap.get(new ComparableItemStack(itemStack)) != null) {
            return false;
        }
        RecipeCharger recipeCharger = new RecipeCharger(itemStack, itemStack2, n);
        recipeMap.put(new ComparableItemStackSafe(itemStack), recipeCharger);
        return true;
    }

    public static boolean removeRecipe(ItemStack itemStack) {
        return recipeMap.remove(new ComparableItemStackSafe(itemStack)) != null;
    }

    public static void addOreDictRecipe(String string, ItemStack itemStack) {
        ChargerManager.addOreDictRecipe(4000, string, itemStack);
    }

    public static void addOreDictRecipe(int n, String string, ItemStack itemStack) {
        if (ItemHelper.oreNameExists((String)string)) {
            ChargerManager.addRecipe(n, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionaryArbiter.getOres((String)string).get(0)), (int)1), itemStack, false);
        }
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("RecipeManagers.Charger", "AllowRecipeOverwrite", false);
    }

    public static class RecipeCharger
    implements IChargerRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        RecipeCharger(ItemStack itemStack, ItemStack itemStack2, int n) {
            this.input = itemStack;
            this.output = itemStack2;
            this.energy = n;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }
    }
}

