/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.classloading;

import cpw.mods.fml.common.FMLLog;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class FluidIdTransformer
implements IClassTransformer {
    private static final String FLUID_TYPE = "net/minecraftforge/fluids/FluidStack";
    private static final String GETID_NAME = "getFluidID";
    private static final String LEGACY_FIELDNAME = "fluidID";
    private static final String GETID_DESC = "()I";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            ListIterator it = m.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                if (insnNode.getType() != 4) continue;
                FieldInsnNode fi = (FieldInsnNode)insnNode;
                if (!FLUID_TYPE.equals(fi.owner) || !LEGACY_FIELDNAME.equals(fi.name) || fi.getOpcode() != 180) continue;
                FMLLog.fine("Method %s.%s%s: Replacing GETFIELD fluidID with INVOKEVIRTUAL getFluidID", name, m.name, m.desc);
                it.remove();
                MethodInsnNode replace = new MethodInsnNode(182, FLUID_TYPE, GETID_NAME, GETID_DESC, false);
                it.add(replace);
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

