/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.quest.worldManager;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.quest.worldManager.WorldManagerBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TerrainManager
extends WorldManagerBase {
    public static TerrainManager instance;
    int territorySeparation;
    List<String> uniqueDungeonsSpawned;

    public TerrainManager(int territorySeparation) {
        this.territorySeparation = territorySeparation;
        this.uniqueDungeonsSpawned = new ArrayList<String>();
    }

    public static int getTerritorySeparation() {
        return instance == null ? ChocolateQuest.config.dungeonSeparation : TerrainManager.instance.territorySeparation;
    }

    public boolean isDungeonSpawned(String name) {
        return this.uniqueDungeonsSpawned.contains(name);
    }

    public void dungeonSpawned(String name) {
        this.uniqueDungeonsSpawned.add(name);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        int tags;
        this.territorySeparation = tag.func_74762_e("Separation");
        NBTTagList list = (NBTTagList)tag.func_74781_a("dungeons");
        if (list != null && (tags = list.func_74745_c()) > 0) {
            for (int i = 0; i < tags; ++i) {
                this.uniqueDungeonsSpawned.add(list.func_150305_b(i).func_74779_i("name"));
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("Separation", this.territorySeparation);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.uniqueDungeonsSpawned.size(); ++i) {
            NBTTagCompound nameTag = new NBTTagCompound();
            nameTag.func_74778_a("name", this.uniqueDungeonsSpawned.get(i));
            list.func_74742_a((NBTBase)nameTag);
        }
        tag.func_74782_a("dungeons", (NBTBase)list);
    }
}

