/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.quest;

import com.chocolate.chocolateQuest.entity.npc.EntityHumanNPC;
import com.chocolate.chocolateQuest.quest.DialogActionCommand;
import com.chocolate.chocolateQuest.quest.DialogActionConsumeItem;
import com.chocolate.chocolateQuest.quest.DialogActionCreateCounter;
import com.chocolate.chocolateQuest.quest.DialogActionEnchant;
import com.chocolate.chocolateQuest.quest.DialogActionGiveItem;
import com.chocolate.chocolateQuest.quest.DialogActionGlobalVariable;
import com.chocolate.chocolateQuest.quest.DialogActionInventory;
import com.chocolate.chocolateQuest.quest.DialogActionJoinTeam;
import com.chocolate.chocolateQuest.quest.DialogActionList;
import com.chocolate.chocolateQuest.quest.DialogActionNPCVariable;
import com.chocolate.chocolateQuest.quest.DialogActionReputation;
import com.chocolate.chocolateQuest.quest.DialogActionSetAI;
import com.chocolate.chocolateQuest.quest.DialogActionSetCurrentPositionHome;
import com.chocolate.chocolateQuest.quest.DialogActionSetItem;
import com.chocolate.chocolateQuest.quest.DialogActionSetNBT;
import com.chocolate.chocolateQuest.quest.DialogActionSetOwner;
import com.chocolate.chocolateQuest.quest.DialogActionSetTimer;
import com.chocolate.chocolateQuest.quest.DialogActionShop;
import com.chocolate.chocolateQuest.quest.DialogActionSpawnMonster;
import com.chocolate.chocolateQuest.quest.DialogCondition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class DialogAction {
    public String name = "";
    public int value = 0;
    public int operator = 0;
    public NBTTagCompound actionTag;
    public List<DialogCondition> conditions = null;
    public static DialogActionList[] actions = new DialogActionList[]{new DialogActionList(DialogActionShop.class, "Open shop"), new DialogActionList(DialogActionEnchant.class, "Open item upgrade"), new DialogActionList(DialogActionInventory.class, "Open inventory"), new DialogActionList(DialogActionJoinTeam.class, "Join team"), new DialogActionList(DialogActionNPCVariable.class, "NPC variable"), new DialogActionList(DialogActionGlobalVariable.class, "Global variable"), new DialogActionList(DialogActionReputation.class, "Reputation"), new DialogActionList(DialogActionGiveItem.class, "Give item"), new DialogActionList(DialogActionConsumeItem.class, "Consume item"), new DialogActionList(DialogActionCommand.class, "Command"), new DialogActionList(DialogActionSetOwner.class, "Set owner"), new DialogActionList(DialogActionSetItem.class, "Set equipement"), new DialogActionList(DialogActionSetAI.class, "Set AI"), new DialogActionList(DialogActionSetNBT.class, "Load data from NBT"), new DialogActionList(DialogActionSpawnMonster.class, "Spawn monster"), new DialogActionList(DialogActionCreateCounter.class, "Kill counter"), new DialogActionList(DialogActionSetTimer.class, "Timer"), new DialogActionList(DialogActionSetCurrentPositionHome.class, "Set current position as home")};
    public static final int SHOP = 0;
    public static final int ENCHANT = 1;
    public static final int INVENTORY = 2;
    public static final int JOIN_TEAM = 3;
    public static final int NPC_VARIABLE = 4;
    public static final int GLOBAL_VARIABLE = 5;
    public static final int REPUTATION = 6;
    public static final int GIVE_ITEM = 7;
    public static final int CONSUME_ITEM = 8;
    public static final int COMMAND = 9;
    public static final int SET_OWNER = 10;
    public static final int SET_EQUIPEMENT = 11;
    public static final int SET_AI = 12;
    public static final int NBT_READ = 13;
    public static final int SPAWN_MONSTER = 14;
    public static final int KILL_COUNTER = 15;
    public static final int SET_TIMER = 16;
    public static final int SET_CURRENT_POSITION_HOME = 17;
    static final String[] operations = new String[]{"SET", "ADD", "SUBSTRACT"};

    public void execute(EntityPlayer player, EntityHumanNPC npc) {
    }

    public int operateValue(int originalValue) {
        switch (this.operator) {
            case 0: {
                return this.value;
            }
            case 1: {
                return originalValue + this.value;
            }
            case 2: {
                return originalValue - this.value;
            }
        }
        return this.value;
    }

    public String operateName(EntityPlayer player) {
        if (this.name.contains("@sp")) {
            this.name = this.name.replace("@sp", player.func_70005_c_());
        }
        return this.name;
    }

    public static DialogAction getFromNBT(NBTTagCompound tag) {
        byte type = tag.func_74771_c("Type");
        try {
            DialogAction action = DialogAction.actions[type].dialogClass.newInstance();
            action.readFromNBT(tag);
            return action;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract byte getType();

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a("Type", this.getType());
        if (this.hasName()) {
            tag.func_74778_a("Name", this.name);
        }
        if (this.hasValue()) {
            tag.func_74768_a("Value", this.value);
        }
        if (this.hasOperator()) {
            tag.func_74768_a("Operator", this.operator);
        }
        if (this.hasTag() && this.actionTag != null) {
            tag.func_74782_a("ActionTag", (NBTBase)this.actionTag);
        }
        if (this.conditions != null) {
            NBTTagList list = new NBTTagList();
            for (DialogCondition condition : this.conditions) {
                NBTTagCompound conditionTag = new NBTTagCompound();
                condition.writeToNBT(conditionTag);
                list.func_74742_a((NBTBase)conditionTag);
            }
            tag.func_74782_a("Conditions", (NBTBase)list);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (this.hasName()) {
            this.name = tag.func_74779_i("Name");
        }
        if (this.hasValue()) {
            this.value = tag.func_74762_e("Value");
        }
        if (this.hasOperator()) {
            this.operator = tag.func_74762_e("Operator");
        }
        if (this.hasTag() && tag.func_74764_b("ActionTag")) {
            this.actionTag = (NBTTagCompound)tag.func_74781_a("ActionTag");
        }
        if (tag.func_74764_b("Conditions")) {
            NBTTagList list = (NBTTagList)tag.func_74781_a("Conditions");
            int optionCount = list.func_74745_c();
            for (int i = 0; i < optionCount; ++i) {
                this.addCondition(DialogCondition.getFromNBT(list.func_150305_b(i)));
            }
        }
    }

    public void addCondition(DialogCondition newDialog) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<DialogCondition>();
        }
        this.conditions.add(newDialog);
    }

    public void removeCondition(DialogCondition condition) {
        this.conditions.remove(condition);
    }

    public boolean hasName() {
        return true;
    }

    public String getNameForName() {
        return "Name";
    }

    public int getSelectorForName() {
        return 0;
    }

    public boolean hasValue() {
        return false;
    }

    public String getNameForValue() {
        return "Value";
    }

    public int getSelectorForValue() {
        return 1;
    }

    public boolean hasOperator() {
        return false;
    }

    public String getNameForOperator() {
        return "Operation";
    }

    public int getSelectorForOperator() {
        return 2;
    }

    public String[] getOptionsForOperator() {
        return operations;
    }

    public boolean hasTag() {
        return false;
    }

    public String toString() {
        String s = actions[this.getType()].toString();
        if (this.hasName()) {
            s = s + " | " + this.getNameString();
        }
        if (this.hasOperator()) {
            s = s + " | " + this.getOperatorString(this.operator);
        }
        if (this.hasValue()) {
            s = s + " | " + this.value;
        }
        return s;
    }

    public String getNameString() {
        return this.name;
    }

    public String getOperatorString(int operator) {
        return this.getOptionsForOperator()[operator];
    }

    public String getValueString(int operator) {
        return this.getOptionsForOperator()[operator];
    }

    public void getSuggestions(List<String> list) {
    }

    public DialogAction copy() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return DialogAction.getFromNBT(tag);
    }
}

