/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.packets;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.npc.EntityHumanNPC;
import com.chocolate.chocolateQuest.gui.guinpc.GuiNPC;
import com.chocolate.chocolateQuest.packets.ChannelHandlerClient;
import com.chocolate.chocolateQuest.packets.PacketBase;
import com.chocolate.chocolateQuest.quest.DialogCondition;
import com.chocolate.chocolateQuest.quest.DialogOption;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketStartConversation
implements IMessage,
IMessageHandler<PacketStartConversation, IMessage> {
    int npcID;
    EntityHumanNPC npc;
    EntityPlayer playerSpeakingTo;
    DialogOption options;
    int[] breadCrumbs;

    public PacketStartConversation() {
    }

    public PacketStartConversation(EntityHumanNPC npc, int[] breadCrumbs, EntityPlayer playerSpeakingTo) {
        this.npcID = npc.func_145782_y();
        this.npc = npc;
        this.breadCrumbs = breadCrumbs;
        this.playerSpeakingTo = playerSpeakingTo;
    }

    public IMessage onMessage(PacketStartConversation message, MessageContext ctx) {
        message.execute(ChannelHandlerClient.getClientPlayer());
        return null;
    }

    public void execute(EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(this.npcID);
        if (entity instanceof EntityHumanNPC) {
            this.npc = (EntityHumanNPC)entity;
            if (GuiNPC.instance == null || this.breadCrumbs.length == 0) {
                if (this.breadCrumbs.length == 0) {
                    this.npc.conversation = this.options;
                    player.openGui((Object)ChocolateQuest.instance, 6, player.field_70170_p, this.npcID, 0, 0);
                }
            } else {
                GuiNPC.instance.setDialogOption(this.options, this.breadCrumbs);
            }
        }
    }

    public void fromBytes(ByteBuf bytes) {
        this.npcID = bytes.readInt();
        this.options = this.readOption(bytes);
        int length = bytes.readInt();
        this.breadCrumbs = new int[length];
        for (int i = 0; i < this.breadCrumbs.length; ++i) {
            this.breadCrumbs[i] = bytes.readInt();
        }
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeInt(this.npcID);
        DialogOption conversation = this.npc.getDialogOption(this.breadCrumbs);
        this.writeOption(bytes, conversation);
        bytes.writeInt(this.breadCrumbs.length);
        for (int i : this.breadCrumbs) {
            bytes.writeInt(i);
        }
    }

    public void writeOption(ByteBuf bytes, DialogOption mainOption) {
        bytes.writeInt(mainOption.id);
        PacketBase.writeString(bytes, mainOption.folder);
        PacketBase.writeString(bytes, mainOption.name);
        if (mainOption.options != null) {
            ArrayList<DialogOption> list = new ArrayList<DialogOption>();
            for (DialogOption option : mainOption.options) {
                boolean shouldOptionPass = true;
                if (option.conditions != null) {
                    for (DialogCondition condition : option.conditions) {
                        if (condition.matches(this.playerSpeakingTo, this.npc)) continue;
                        shouldOptionPass = false;
                        break;
                    }
                }
                if (!shouldOptionPass) continue;
                list.add(option);
            }
            bytes.writeInt(list.size());
            for (DialogOption option : list) {
                bytes.writeInt(option.id);
                PacketBase.writeString(bytes, option.folder);
                PacketBase.writeString(bytes, option.name);
            }
        } else {
            bytes.writeInt(0);
        }
    }

    public DialogOption readOption(ByteBuf bytes) {
        DialogOption option = new DialogOption();
        option.id = bytes.readInt();
        option.folder = PacketBase.readString(bytes);
        option.name = PacketBase.readString(bytes);
        int length = bytes.readInt();
        if (length > 0) {
            DialogOption[] options = new DialogOption[length];
            for (int i = 0; i < options.length; ++i) {
                options[i] = new DialogOption();
                options[i].id = bytes.readInt();
                options[i].folder = PacketBase.readString(bytes);
                options[i].name = PacketBase.readString(bytes);
            }
            option.options = options;
        }
        return option;
    }
}

