/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.magic;

import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.magic.SpellBase;
import com.chocolate.chocolateQuest.utils.HelperPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SpellStorm
extends SpellBase {
    @Override
    public void onShoot(EntityLivingBase shooter, Elements element, ItemStack is, int chargeTime) {
        World world = shooter.field_70170_p;
        if (!world.field_72995_K) {
            if (shooter instanceof EntityPlayer) {
                MovingObjectPosition mop = HelperPlayer.getBlockMovingObjectPositionFromPlayer(shooter.field_70170_p, shooter, 60.0, true);
                if (mop != null) {
                    this.shootBallAt(shooter, element, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, is);
                } else {
                    Vec3 look = shooter.func_70040_Z();
                    double dist = 10.0;
                    this.shootBallAt(shooter, element, shooter.field_70165_t + look.field_72450_a * dist, shooter.field_70163_u, shooter.field_70161_v + look.field_72449_c * dist, is);
                }
            } else {
                Vec3 look = shooter.func_70040_Z();
                double dist = 10.0;
                EntityLivingBase target = ((EntityLiving)shooter).func_70638_az();
                if (target != null) {
                    dist = shooter.func_70032_d((Entity)target);
                }
                this.shootBallAt(shooter, element, shooter.field_70165_t + look.field_72450_a * dist, shooter.field_70163_u, shooter.field_70161_v + look.field_72449_c * dist, is);
            }
        }
    }

    public void shootBallAt(EntityLivingBase shooter, Elements element, double x, double y, double z, ItemStack is) {
        World world = shooter.field_70170_p;
        int type = this.getType();
        EntityBaseBall ball = new EntityBaseBall(world, shooter, type, this.getExpansion(is), element);
        ball.field_70165_t = x;
        ball.field_70163_u = y;
        ball.field_70161_v = z;
        ball.setDamageMultiplier(1.0f + (float)this.getDamage(is) * 0.25f);
        world.func_72838_d((Entity)ball);
    }

    @Override
    public int getCoolDown() {
        return 300;
    }

    @Override
    public int getRange(ItemStack itemstack) {
        return 32;
    }

    @Override
    public int getCastingTime() {
        return 40;
    }

    public int getType() {
        return 104;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }
}

