/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items.mobControl;

import com.chocolate.chocolateQuest.entity.EntityCursor;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.utils.BDHelper;
import com.chocolate.chocolateQuest.utils.HelperPlayer;
import com.chocolate.chocolateQuest.utils.Vec4I;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemPathMarker
extends Item {
    ArrayList<EntityCursor> cursors = new ArrayList();
    ItemStack currentItem;

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af() && itemstack.field_77990_d != null) {
            this.spawnCursors(world, itemstack);
            this.removePoint(itemstack, entityPlayer);
        } else {
            Entity target = HelperPlayer.getTarget((EntityLivingBase)entityPlayer, world, 6.0);
            MovingObjectPosition mop = HelperPlayer.getMovingObjectPositionFromPlayer((EntityLivingBase)entityPlayer, world, 50.0);
            if (mop != null && mop.field_72308_g == null) {
                if (itemstack.field_77990_d == null) {
                    itemstack.field_77990_d = new NBTTagCompound();
                    itemstack.func_77964_b(field_77697_d.nextInt(16));
                }
                if (this.addPoint(itemstack, entityPlayer, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) && world.field_72995_K) {
                    this.spawnCursors(world, itemstack);
                }
            }
        }
        return super.func_77659_a(itemstack, world, entityPlayer);
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity par3Entity, int par4, boolean par5) {
        if (world.field_72995_K && par3Entity instanceof EntityPlayer) {
            boolean itemChanged = false;
            EntityPlayer player = (EntityPlayer)par3Entity;
            if (player.field_71071_by.func_70448_g() != null) {
                ItemStack playerCurrentItem = player.field_71071_by.func_70448_g();
                if (playerCurrentItem.func_77973_b() == this) {
                    if (this.currentItem == null || !playerCurrentItem.func_77969_a(this.currentItem)) {
                        this.currentItem = playerCurrentItem;
                        itemChanged = true;
                    }
                } else {
                    itemChanged = true;
                    this.currentItem = null;
                }
            } else {
                this.currentItem = null;
            }
            if (itemChanged && this.currentItem != null) {
                this.spawnCursors(world, this.currentItem);
            }
        }
        super.func_77663_a(itemstack, world, par3Entity, par4, par5);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityHumanBase && stack.field_77990_d != null) {
            int points = stack.field_77990_d.func_74762_e("pos");
            if (points < 2) {
                return false;
            }
            Vec4I[] path = new Vec4I[points];
            for (int p = 0; p < points; ++p) {
                path[p] = new Vec4I(stack.field_77990_d.func_74762_e("x" + p), stack.field_77990_d.func_74762_e("y" + p), stack.field_77990_d.func_74762_e("z" + p), 0);
            }
            ((EntityHumanBase)entity).path = path;
            if (player.field_70170_p.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Assigned path for " + BDHelper.StringColor("2") + entity.func_70005_c_()));
            }
        }
        return true;
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return par1ItemStack.field_77990_d != null;
    }

    public boolean addPoint(ItemStack itemstack, EntityPlayer entityPlayer, int blockX, int blockY, int blockZ) {
        int point = itemstack.field_77990_d.func_74762_e("pos");
        if (point >= this.getMaxPoints(itemstack)) {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Can't add more points"));
            return false;
        }
        if (point > 0) {
            double dist;
            int x = itemstack.field_77990_d.func_74762_e("x" + (point - 1));
            int y = itemstack.field_77990_d.func_74762_e("y" + (point - 1));
            int z = itemstack.field_77990_d.func_74762_e("z" + (point - 1));
            if ((dist = Math.sqrt((x -= blockX) * x + (y -= blockY) * y + (z -= blockZ) * z)) > 30.0) {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Too far from previous point"));
                return false;
            }
        }
        itemstack.field_77990_d.func_74768_a("x" + point, blockX);
        itemstack.field_77990_d.func_74768_a("y" + point, blockY);
        itemstack.field_77990_d.func_74768_a("z" + point, blockZ);
        itemstack.field_77990_d.func_74768_a("rot" + point, (int)entityPlayer.field_70177_z);
        itemstack.field_77990_d.func_74768_a("pos", point + 1);
        return true;
    }

    public int getMaxPoints(ItemStack is) {
        return 32;
    }

    public boolean removePoint(ItemStack itemstack, EntityPlayer entityPlayer) {
        if (itemstack.field_77990_d != null) {
            EntityCursor e;
            int currentPoint = Math.max(0, itemstack.field_77990_d.func_74762_e("pos") - 1);
            itemstack.field_77990_d.func_74768_a("pos", currentPoint);
            if (currentPoint > 0 && entityPlayer.field_70170_p.field_72995_K && (e = this.cursors.get(currentPoint)) != null) {
                e.item = null;
                e.func_70106_y();
            }
            if (currentPoint == 0) {
                itemstack.field_77990_d = null;
            }
        }
        return true;
    }

    public void spawnCursors(World world, ItemStack itemstack) {
        if (world.field_72995_K && itemstack.field_77990_d != null) {
            for (EntityCursor e : this.cursors) {
                e.item = null;
                e.func_70106_y();
            }
            this.cursors.clear();
            int points = itemstack.field_77990_d.func_74762_e("pos");
            for (int p = 0; p < points; ++p) {
                EntityCursor c = new EntityCursor(world, (double)itemstack.field_77990_d.func_74762_e("x" + p) + 0.5, itemstack.field_77990_d.func_74762_e("y" + p) + 1, (double)itemstack.field_77990_d.func_74762_e("z" + p) + 0.5, itemstack.field_77990_d.func_74762_e("rot" + p), itemstack);
                if (p >= 1) {
                    this.cursors.get((int)(p - 1)).next = c;
                }
                this.cursors.add(c);
                world.func_72838_d((Entity)c);
            }
        }
    }
}

