/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.gui.guinpc;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ShopRecipe {
    public ItemStack tradedItem;
    public ItemStack[] costItems;

    public ShopRecipe(ItemStack tradedItem, ItemStack[] costItems) {
        this.tradedItem = tradedItem;
        this.costItems = costItems;
    }

    public ShopRecipe(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public ShopRecipe(NBTTagCompound nbt, boolean readWithMapping) {
        if (readWithMapping) {
            this.readFromNBTWithMapping(nbt);
        } else {
            this.readFromNBT(nbt);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList priceListTag = (NBTTagList)nbt.func_74781_a("items");
        this.tradedItem = ItemStack.func_77949_a((NBTTagCompound)priceListTag.func_150305_b(0));
        this.costItems = new ItemStack[priceListTag.func_74745_c() - 1];
        for (int i = 1; i < priceListTag.func_74745_c(); ++i) {
            this.costItems[i - 1] = ItemStack.func_77949_a((NBTTagCompound)priceListTag.func_150305_b(i));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList priceListTag = new NBTTagList();
        NBTTagCompound tradedItemTag = new NBTTagCompound();
        this.tradedItem.func_77955_b(tradedItemTag);
        priceListTag.func_74742_a((NBTBase)tradedItemTag);
        for (int i = 1; i < this.costItems.length + 1; ++i) {
            NBTTagCompound priceItemTag = new NBTTagCompound();
            this.costItems[i - 1].func_77955_b(priceItemTag);
            priceListTag.func_74742_a((NBTBase)priceItemTag);
        }
        nbt.func_74782_a("items", (NBTBase)priceListTag);
    }

    public void readFromNBTWithMapping(NBTTagCompound nbt) {
        NBTTagList list = (NBTTagList)nbt.func_74781_a("items");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String id = list.func_150305_b(i).func_74779_i("name");
            Item item = (Item)Item.field_150901_e.func_82594_a(id);
            if (item == null) continue;
            short newID = (short)Item.func_150891_b((Item)item);
            list.func_150305_b(i).func_74777_a("id", newID);
        }
        this.readFromNBT(nbt);
    }

    public void writeToNBTWithMapping(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
        NBTTagList list = (NBTTagList)nbt.func_74781_a("items");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String id = "";
            id = i == 0 ? Item.field_150901_e.func_148750_c((Object)this.tradedItem.func_77973_b()) : Item.field_150901_e.func_148750_c((Object)this.costItems[i - 1].func_77973_b());
            list.func_150305_b(i).func_74778_a("name", id);
        }
    }
}

