/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.gui.guinpc;

import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiScrollOptions
extends GuiButton {
    FontRenderer font;
    int selectedMode = 0;
    public String[] modeNames;
    int scrollAmmount;
    boolean drag = false;
    int MAX_ENTRIES = 4;
    int SCROLL_WIDTH = 8;
    int MAX_ENTRIES_FINAL = 4;

    public GuiScrollOptions(int id, int posX, int posY, int width, int height, FontRenderer font) {
        this(id, posX, posY, width, height, new String[]{"Empty"}, font, 0);
    }

    public GuiScrollOptions(int id, int posX, int posY, int width, int height, String[] par5Str, FontRenderer font, int value) {
        this(id, posX, posY, width, height, par5Str, font, value, 4);
    }

    public GuiScrollOptions(int id, int posX, int posY, int width, int height, String[] par5Str, FontRenderer font, int value, int maxEntries) {
        super(id, posX, posY, width, height, "");
        this.font = font;
        this.selectedMode = value;
        this.MAX_ENTRIES_FINAL = maxEntries;
        this.setModeNames(par5Str);
    }

    public void setModeNames(String[] modeNames) {
        this.modeNames = modeNames;
        this.MAX_ENTRIES = Math.min(Math.max(1, modeNames.length), this.MAX_ENTRIES_FINAL);
        if (this.selectedMode > this.MAX_ENTRIES) {
            this.selectedMode = -1;
        }
        this.scrollAmmount = 0;
    }

    public void func_146112_a(Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_146124_l) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(BDHelper.guiButtonsTexture);
            int buttonHeight = this.field_146121_g / this.MAX_ENTRIES;
            for (int i = 0; i < this.MAX_ENTRIES; ++i) {
                int y = this.field_146129_i + buttonHeight * i;
                this.drawTexturedRect(this.field_146128_h, y, this.field_146120_f, buttonHeight, 6.0f, 0.0f, 3.0f, 1.0f);
            }
            int currentPosition = this.selectedMode - this.scrollAmmount;
            if (currentPosition >= 0 && currentPosition < this.MAX_ENTRIES) {
                int currentX = this.field_146128_h;
                int currentY = this.field_146129_i + buttonHeight * currentPosition;
                this.drawSelected(currentX, currentY);
            }
            if (this.modeNames.length - this.MAX_ENTRIES > 0) {
                this.drawTexturedRect(this.field_146128_h + this.field_146120_f - this.SCROLL_WIDTH, this.field_146129_i, this.SCROLL_WIDTH, this.field_146121_g, 15.5f, 2.0f, 0.5f, 4.0f);
                int scrollY = this.scrollAmmount * (this.field_146121_g - this.SCROLL_WIDTH) / (this.modeNames.length - this.MAX_ENTRIES);
                this.drawTexturedRect(this.field_146128_h + this.field_146120_f - this.SCROLL_WIDTH, this.field_146129_i + scrollY, this.SCROLL_WIDTH, this.SCROLL_WIDTH, 15.0f, 2.0f, 0.5f, 0.5f);
            }
            this.drawText(null, buttonHeight);
            this.func_146119_b(par1Minecraft, par2, par3);
        }
    }

    public void drawText(Minecraft par1Minecraft, int buttonHeight) {
        for (int i = 0; i < this.MAX_ENTRIES && this.scrollAmmount + i < this.modeNames.length; ++i) {
            int y = this.field_146129_i + buttonHeight * i;
            this.func_73731_b(this.font, this.modeNames[this.scrollAmmount + i], this.field_146128_h + 5, y + buttonHeight / 2 - 5, 0xFFFFFF);
        }
    }

    public void drawSelected(int x, int y) {
        int buttonHeight = this.field_146121_g / this.MAX_ENTRIES;
        this.drawTexturedRect(x, y, this.field_146120_f, buttonHeight, 6.0f, 1.0f, 3.0f, 1.0f);
    }

    public void drawTexturedRect(int x, int y, int size, int height, float indexX, float indexZ, float iconWidth, float iconHeight) {
        float f = 0.0625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, (double)((indexX + 0.0f) * f), (double)((indexZ + iconHeight) * f));
        tessellator.func_78374_a((double)(x + size), (double)(y + height), (double)this.field_73735_i, (double)((indexX + iconWidth) * f), (double)((indexZ + iconHeight) * f));
        tessellator.func_78374_a((double)(x + size), (double)(y + 0), (double)this.field_73735_i, (double)((indexX + iconWidth) * f), (double)((indexZ + 0.0f) * f));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)((indexX + 0.0f) * f), (double)((indexZ + 0.0f) * f));
        tessellator.func_78381_a();
    }

    protected void func_146119_b(Minecraft par1Minecraft, int x, int y) {
        if (this.drag && this.field_146124_l && this.field_146125_m && x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g) {
            this.handleMouseScroll(x, y);
        } else {
            this.drag = false;
        }
        super.func_146119_b(par1Minecraft, x, y);
    }

    public void func_146118_a(int x, int y) {
        this.drag = false;
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int x, int y) {
        if (super.func_146116_c(par1Minecraft, x, y)) {
            if (this.handleMouseScroll(x, y)) {
                return false;
            }
            this.selectedMode = (y - this.field_146129_i) * this.MAX_ENTRIES / this.field_146121_g + this.scrollAmmount;
            return true;
        }
        return false;
    }

    public boolean handleMouseScroll(int x, int y) {
        if (x - this.field_146128_h > this.field_146120_f - this.SCROLL_WIDTH) {
            this.scrollAmmount = (y - this.field_146129_i) * (this.modeNames.length - this.MAX_ENTRIES + 1) / this.field_146121_g;
            return true;
        }
        return false;
    }

    public void scrollDown() {
        if (this.selectedMode < this.modeNames.length - 1) {
            ++this.selectedMode;
            if (this.selectedMode - this.MAX_ENTRIES >= this.scrollAmmount) {
                ++this.scrollAmmount;
            }
        }
    }

    public void scrollUp() {
        if (this.selectedMode > 0) {
            --this.selectedMode;
            if (this.selectedMode < this.scrollAmmount) {
                --this.scrollAmmount;
            }
        }
    }

    public String getSelected() {
        return this.modeNames[this.selectedMode];
    }
}

