/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.gui;

import com.chocolate.chocolateQuest.gui.TextField;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;

@SideOnly(value=Side.CLIENT)
public class GuiButtonTextBoxList
extends GuiButton {
    public GuiTextField[] textbox;
    FontRenderer fontRenderer;
    int scroll = 0;
    List<String> values = new ArrayList<String>();
    final int TEXT_BOXES = 4;

    public GuiButtonTextBoxList(int id, int posX, int posY, int width, int height, FontRenderer font, String[] values) {
        super(id, posX, posY, width, height, "");
        this.fontRenderer = font;
        this.textbox = new GuiTextField[4];
        for (int i = 0; i < this.textbox.length; ++i) {
            this.textbox[i] = new TextField(font, posX, posY + i * 20, width, height / 4, this);
            this.textbox[i].func_146203_f(128);
        }
        this.setValues(values);
    }

    public void func_146112_a(Minecraft mc, int x, int y) {
    }

    public String[] getValues() {
        int last = this.values.size();
        while (last > 1 && this.values.get(last - 1).isEmpty()) {
            this.values.remove(last - 1);
            last = this.values.size();
        }
        if (this.values.size() == 0) {
            return new String[]{"Nothing to tell you"};
        }
        String[] s = new String[this.values.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.values.get(i);
        }
        return s;
    }

    public void setValues(String[] text) {
        if (text == null) {
            text = new String[]{""};
        }
        this.values.clear();
        for (String s : text) {
            this.values.add(s);
        }
        this.setTextBoxValues();
    }

    public void setTextBoxValues() {
        for (int i = 0; i < this.textbox.length; ++i) {
            String s = "";
            if (this.scroll + i < this.values.size()) {
                s = this.values.get(this.scroll + i);
            }
            if (s == null) {
                s = "";
            }
            this.textbox[i].func_146180_a(s);
        }
    }

    public void updateValues() {
        for (int i = 0; i < 4; ++i) {
            if (this.values.size() > this.scroll + i) {
                this.values.set(this.scroll + i, this.textbox[i].func_146179_b());
                continue;
            }
            this.values.add(this.textbox[i].func_146179_b());
        }
    }

    public boolean func_146116_c(Minecraft mc, int x, int y) {
        if (super.func_146116_c(mc, x, y)) {
            this.updateValues();
            return true;
        }
        return false;
    }

    public void scrollUp() {
        if (this.scroll > 0) {
            --this.scroll;
        }
        this.setTextBoxValues();
    }

    public void scrollDown() {
        ++this.scroll;
        if (this.values.size() > this.scroll) {
            this.values.add("");
        }
        this.setTextBoxValues();
    }
}

