/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.entity.projectile.ProjectileBase;
import com.chocolate.chocolateQuest.magic.Elements;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;

public class ProjectileMagic
extends ProjectileBase {
    public static final int PHYSIC = 0;
    public static final int MAGIC = 1;
    public static final int BLAST = 2;
    public static final int FIRE = 3;
    int type;
    int damageCounter = 0;

    public ProjectileMagic(EntityBaseBall entity) {
        super(entity);
        this.type = entity.getElement().ordinal();
    }

    @Override
    public int getTextureIndex() {
        if (this.type == 2) {
            return -1;
        }
        return 247 + this.type - (this.entity.field_70173_aa / 4 % 2 == 0 ? 0 : 16);
    }

    @Override
    public void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (!this.entity.field_70170_p.field_72995_K) {
            Entity e = par1MovingObjectPosition.field_72308_g;
            if (e != null) {
                if (e instanceof EntityLivingBase && e != this.entity.shootingEntity) {
                    if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75102_a) {
                        return;
                    }
                    Elements element = this.entity.getElement();
                    DamageSource ds = this.getDamageSource().func_76349_b();
                    float damage = 4.0f * this.entity.getDamageMultiplier();
                    damage = element.onHitEntity((Entity)this.entity.func_85052_h(), e, damage);
                    if (e.func_70097_a(ds, damage)) {
                        ++this.damageCounter;
                    }
                }
            } else {
                this.entity.func_70106_y();
            }
        }
    }

    @Override
    public void onUpdateInAir() {
        if (this.damageCounter > this.entity.getlvl()) {
            this.entity.func_70106_y();
        }
        super.onUpdateInAir();
    }

    protected DamageSource getDamageSource() {
        Elements element;
        switch (this.type) {
            case 1: {
                element = Elements.magic;
                break;
            }
            case 2: {
                element = Elements.blast;
                break;
            }
            case 3: {
                element = Elements.fire;
                break;
            }
            default: {
                element = Elements.physic;
            }
        }
        return element.getDamageSourceIndirect((Entity)this.entity.shootingEntity, (Entity)this.entity);
    }

    @Override
    public float getGravityVelocity() {
        return 0.0f;
    }

    @Override
    public float getSize() {
        return 0.8f;
    }
}

