/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.entity.projectile.ProjectileBase;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.utils.HelperDamageSource;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;

public class ProjectileBulletPistol
extends ProjectileBase {
    public static final int IRON = 0;
    public static final int GOLD = 1;
    public static final int MAGIC = 2;
    public static final int FIRE = 3;
    public static final int CANNON = 4;
    Random rand = new Random();

    public ProjectileBulletPistol(EntityBaseBall entity) {
        super(entity);
    }

    @Override
    public int getTextureIndex() {
        if (this.entity.getlvl() == 1) {
            return 225;
        }
        if (this.entity.getlvl() == 2) {
            return 226;
        }
        if (this.entity.getlvl() == 3) {
            return 227;
        }
        return 224;
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (!this.entity.field_70170_p.field_72995_K) {
            if (mop.field_72308_g != null) {
                if (mop.field_72308_g != this.entity.shootingEntity.field_70153_n && mop.field_72308_g != this.entity.shootingEntity.field_70154_o) {
                    float damage = this.getBulletBaseDamage();
                    byte bulletType = this.entity.getlvl();
                    if (bulletType == 1) {
                        damage += damage * 0.66f;
                    }
                    if (bulletType == 4) {
                        damage *= 2.0f;
                    }
                    DamageSource ds = bulletType == 3 ? Elements.fire.getDamageSourceIndirect((Entity)this.entity.func_85052_h(), (Entity)this.entity) : (bulletType == 2 ? Elements.magic.getDamageSourceIndirect((Entity)this.entity.func_85052_h(), (Entity)this.entity) : Elements.blast.getDamageSourceIndirect((Entity)this.entity.func_85052_h(), (Entity)this.entity));
                    ds.func_76349_b();
                    if (HelperDamageSource.attackEntityWithoutKnockBack(mop.field_72308_g, ds, damage *= this.entity.damageMultiplier)) {
                        if (bulletType != 4) {
                            this.entity.func_70106_y();
                        }
                        if (mop.field_72308_g instanceof EntityLivingBase) {
                            ((EntityLivingBase)mop.field_72308_g).field_70172_ad = 1;
                        }
                        mop.field_72308_g.field_70179_y = 0.0;
                        mop.field_72308_g.field_70159_w = 0.0;
                    }
                }
            } else {
                Material mat = this.entity.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).func_149688_o();
                if (mat != Material.field_151579_a && mat != Material.field_151581_o && mat != Material.field_151585_k && mat != Material.field_151582_l && mat != Material.field_151569_G) {
                    this.entity.func_70106_y();
                }
            }
        }
    }

    protected int getBulletBaseDamage() {
        return 6;
    }

    @Override
    public void onSpawn() {
        this.entity.field_70170_p.func_72956_a((Entity)this.entity, "chocolateQuest:handgun", 0.2f, this.getBulletPitch());
    }

    public float getBulletPitch() {
        return 1.0f;
    }

    @Override
    public void onUpdateInAir() {
        if (this.entity.field_70170_p.field_72995_K) {
            this.entity.field_70170_p.func_72869_a("smoke", this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public float getSize() {
        if (this.entity.getlvl() >= 4) {
            return 0.4f;
        }
        return 0.1f;
    }

    @Override
    public boolean canBounce() {
        return false;
    }
}

