/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.npc;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.ai.EnumAiCombat;
import com.chocolate.chocolateQuest.entity.ai.EnumAiState;
import com.chocolate.chocolateQuest.entity.ai.HumanSelector;
import com.chocolate.chocolateQuest.entity.npc.TimeCounter;
import com.chocolate.chocolateQuest.entity.npc.npcLogic;
import com.chocolate.chocolateQuest.gui.guinpc.ShopRecipe;
import com.chocolate.chocolateQuest.misc.EnumRace;
import com.chocolate.chocolateQuest.misc.EnumVoice;
import com.chocolate.chocolateQuest.packets.ChannelHandler;
import com.chocolate.chocolateQuest.packets.PacketBase;
import com.chocolate.chocolateQuest.packets.PacketEditConversation;
import com.chocolate.chocolateQuest.packets.PacketEditNPC;
import com.chocolate.chocolateQuest.packets.PacketStartConversation;
import com.chocolate.chocolateQuest.packets.PacketUpdateHumanData;
import com.chocolate.chocolateQuest.packets.PacketUpdateHumanDummyData;
import com.chocolate.chocolateQuest.packets.PacketUpdateShopRecipe;
import com.chocolate.chocolateQuest.quest.DialogOption;
import com.chocolate.chocolateQuest.quest.worldManager.ReputationManager;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityHumanNPC
extends EntityHumanBase
implements INpc {
    ShopRecipe[] trades = new ShopRecipe[]{new ShopRecipe(new ItemStack(Items.field_151166_bC), new ItemStack[]{new ItemStack(Items.field_151034_e)})};
    public String texture = "pirate.png";
    public boolean hasPlayerTexture = false;
    public ResourceLocation textureLocationPlayer = null;
    public int modelType;
    public String name = "unnamed";
    public String displayName = "Unknown";
    public float size = 0.5f;
    public int color = 0xFFFFFF;
    public boolean isInvincible = false;
    public int voice;
    public NBTTagCompound npcVariables;
    public DialogOption conversation = new DialogOption(null, "helloWorld");
    DialogOption currentDialog;
    public boolean canTeleport = false;
    public int repToAttack = 0;
    public int repOnDeath = 10;
    public boolean targetMobs = true;
    EntityAINearestAttackableTarget aiTargetMonster;
    public int followTime = 0;
    List<TimeCounter> timers = null;

    public EntityHumanNPC(World world) {
        super(world);
        if (world != null && !world.field_72995_K) {
            this.npcVariables = new NBTTagCompound();
        }
        this.shouldDespawn = false;
        this.AIMode = EnumAiState.FOLLOW.ordinal();
        this.AICombatMode = EnumAiCombat.DEFENSIVE.ordinal();
    }

    @Override
    public void setAIForCurrentMode() {
        super.setAIForCurrentMode();
        this.setTargetsMobs();
    }

    public void setTargetsMobs() {
        if (this.targetMobs && this.aiTargetMonster == null) {
            this.aiTargetMonster = new EntityAINearestAttackableTarget((EntityCreature)this, IMob.class, 0, true, false, (IEntitySelector)new HumanSelector(this));
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)this.aiTargetMonster);
        } else if (!this.targetMobs && this.aiTargetMonster != null) {
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiTargetMonster);
            this.aiTargetMonster = null;
        }
    }

    @Override
    public void func_70636_d() {
        if (this.followTime > 0) {
            if (this.followTime == 1) {
                this.setOwner(null);
            }
            --this.followTime;
        }
        if (this.field_70173_aa % 2000 == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.timers != null) {
            for (int i = 0; i < this.timers.size(); ++i) {
                this.timers.get(i).update();
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float damage) {
        if (this.isInvincible) {
            return false;
        }
        return super.func_70097_a(damagesource, damage);
    }

    @Override
    protected boolean func_70085_c(EntityPlayer player) {
        if (this.playerSpeakingTo == null) {
            if (this.entityTeam.startsWith("mob") && !player.field_71075_bZ.field_75098_d) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                boolean allied;
                String team = this.entityTeam.replace("npc_", "");
                boolean bl = allied = team.equals("npc") || ReputationManager.instance.getPlayerReputation(player.func_70005_c_(), team) >= this.repToAttack;
                if (!allied && player.func_96124_cp() != null) {
                    allied = this.isOnAlliedTeam(player.func_96124_cp());
                }
                if (player.field_71075_bZ.field_75098_d || allied) {
                    this.func_70624_b(null);
                    this.playerSpeakingTo = player;
                    this.openConversation(player);
                }
            }
        }
        return true;
    }

    @Override
    public IMessage getEntityGUIUpdatePacket(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return new PacketUpdateHumanDummyData(this);
        }
        return new PacketUpdateHumanData(this);
    }

    public void openShop(EntityPlayer player) {
        if (this.field_70170_p instanceof WorldServer) {
            PacketUpdateShopRecipe packet = new PacketUpdateShopRecipe(this, -1);
            ChannelHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
            player.openGui((Object)ChocolateQuest.instance, 5, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public void openEnchantment(EntityPlayer player, int type, int level) {
        player.openGui((Object)ChocolateQuest.instance, 7, this.field_70170_p, this.func_145782_y(), type, level);
    }

    public void editNPC(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            PacketEditNPC packet = new PacketEditNPC(this);
            ChannelHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
        }
    }

    public void openConversation(EntityPlayer player) {
        this.conversation.setID(0);
        PacketStartConversation packet = new PacketStartConversation(this, new int[0], player);
        ChannelHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
    }

    public void editConversation(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            PacketEditConversation packet = new PacketEditConversation(this, new int[0]);
            ChannelHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
        }
    }

    public void updateConversation(EntityPlayer player, int[] selectedStep) {
        DialogOption option = this.getDialogOption(selectedStep);
        option.execute(player, this);
        PacketStartConversation packet = new PacketStartConversation(this, selectedStep, player);
        ChannelHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
    }

    public void endConversation() {
        this.playerSpeakingTo = null;
    }

    public DialogOption getDialogOption(int[] selectedStep) {
        DialogOption option = this.conversation;
        for (int i = 0; i < selectedStep.length; ++i) {
            option = option.options[selectedStep[i]];
        }
        return option;
    }

    public int executeCommand(String command) {
        if (this.playerSpeakingTo != null) {
            command = command.replace("@sp", this.playerSpeakingTo.func_70005_c_());
        }
        int returnValue = 0;
        MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
        if (minecraftserver != null && minecraftserver.func_82356_Z()) {
            ICommandManager icommandmanager = minecraftserver.func_71187_D();
            returnValue = icommandmanager.func_71556_a((ICommandSender)new npcLogic(this), command);
        }
        return returnValue;
    }

    public ShopRecipe[] getRecipes() {
        return this.trades;
    }

    public void setRecipes(int i, ShopRecipe recipe) {
        if (this.trades == null) {
            this.trades = new ShopRecipe[1];
        }
        if (i >= this.trades.length) {
            i = this.trades.length;
            ShopRecipe[] newTrades = new ShopRecipe[i + 1];
            for (int t = 0; t < newTrades.length - 1; ++t) {
                newTrades[t] = this.trades[t];
            }
            this.trades = newTrades;
        }
        this.trades[i] = recipe;
    }

    public void setRecipes(ShopRecipe[] recipes) {
        this.trades = recipes;
    }

    public String func_70005_c_() {
        return this.displayName;
    }

    public void loadFromTag(NBTTagCompound tag) {
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        NBTTagCompound tagOriginal = new NBTTagCompound();
        this.func_70014_b(tagOriginal);
        for (String s : tag.func_150296_c()) {
            NBTBase nbtbase = tag.func_74781_a(s);
            tagOriginal.func_74782_a(s, nbtbase);
        }
        this.func_70020_e(tagOriginal);
        this.func_70107_b(x, y, z);
    }

    public void updateStats(NBTTagCompound tag) {
        if (tag.func_74764_b("CustomNameVisible")) {
            this.func_94061_f(tag.func_74767_n("CustomNameVisible"));
        }
        if (tag.func_74764_b("CanPickUpLoot")) {
            this.func_98053_h(tag.func_74767_n("CanPickUpLoot"));
        }
        if (tag.func_74764_b("nameID")) {
            this.name = tag.func_74779_i("nameID");
        }
        if (tag.func_74764_b("displayName")) {
            this.displayName = tag.func_74779_i("displayName");
        }
        if (tag.func_74764_b("texture")) {
            this.texture = tag.func_74779_i("texture");
        }
        if (tag.func_74764_b("model")) {
            this.modelType = tag.func_74762_e("model");
        }
        if (tag.func_74764_b("sizeModifier")) {
            this.size = tag.func_74760_g("sizeModifier");
            this.resize();
        }
        if (tag.func_74764_b("colorMod")) {
            this.color = tag.func_74762_e("colorMod");
        }
        if (tag.func_74764_b("playerTexture")) {
            this.hasPlayerTexture = tag.func_74767_n("playerTexture");
        }
        if (tag.func_74764_b("gender")) {
            this.isMale = tag.func_74767_n("gender");
        }
        if (tag.func_74764_b("team")) {
            this.entityTeam = tag.func_74779_i("team");
        }
        if (tag.func_74764_b("isInvincible")) {
            this.isInvincible = tag.func_74767_n("isInvincible");
        }
        if (tag.func_74764_b("targetMobs")) {
            this.targetMobs = tag.func_74767_n("targetMobs");
        }
        if (tag.func_74764_b("teleport")) {
            this.canTeleport = tag.func_74767_n("teleport");
        }
        if (tag.func_74764_b("voice")) {
            this.voice = tag.func_74762_e("voice");
        }
        if (tag.func_74764_b("repOnKill")) {
            this.repOnDeath = tag.func_74762_e("repOnKill");
        }
        if (tag.func_74764_b("repFriendly")) {
            this.repToAttack = tag.func_74762_e("repFriendly");
        }
        if (tag.func_74764_b("health")) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)tag.func_74762_e("health"));
        }
        if (tag.func_74764_b("speed")) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)tag.func_74762_e("speed") * 0.001);
        }
        if (tag.func_74764_b("homeX") && tag.func_74764_b("homeY") && tag.func_74764_b("homeZ")) {
            int x = tag.func_74762_e("homeX");
            int y = tag.func_74762_e("homeY");
            int z = tag.func_74762_e("homeZ");
            this.func_110171_b(x, y, z, -1);
        }
        if (tag.func_74764_b("homeDist")) {
            int dist = tag.func_74762_e("homeDist");
            this.func_110171_b(this.func_110172_bL().field_71574_a, this.func_110172_bL().field_71572_b, this.func_110172_bL().field_71573_c, dist);
        }
    }

    public void writeStats(NBTTagCompound tag, boolean writeAll) {
        tag.func_74757_a("CustomNameVisible", this.func_94062_bN());
        tag.func_74757_a("CanPickUpLoot", this.func_98052_bS());
        tag.func_74778_a("nameID", this.name);
        tag.func_74778_a("displayName", this.displayName);
        tag.func_74757_a("gender", this.isMale);
        tag.func_74757_a("playerTexture", this.hasPlayerTexture);
        tag.func_74768_a("model", this.modelType);
        tag.func_74778_a("texture", this.texture);
        tag.func_74776_a("sizeModifier", this.size);
        tag.func_74768_a("colorMod", this.color);
        tag.func_74757_a("isInvincible", this.isInvincible);
        tag.func_74757_a("targetMobs", this.targetMobs);
        tag.func_74757_a("teleport", this.canTeleport);
        tag.func_74768_a("voice", this.voice);
        tag.func_74768_a("repFriendly", this.repToAttack);
        tag.func_74768_a("repOnKill", this.repOnDeath);
        if (writeAll) {
            tag.func_74768_a("homeX", this.func_110172_bL().field_71574_a);
            tag.func_74768_a("homeY", this.func_110172_bL().field_71572_b);
            tag.func_74768_a("homeZ", this.func_110172_bL().field_71573_c);
            tag.func_74768_a("homeDist", (int)this.getHomeDistance());
            tag.func_74778_a("team", this.entityTeam);
            tag.func_74768_a("health", (int)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
            tag.func_74768_a("speed", (int)(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 1000.0));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.writeShop(nbttagcompound, false);
        if (this.conversation != null) {
            NBTTagCompound optionTag = new NBTTagCompound();
            this.conversation.writeToNBT(optionTag);
            nbttagcompound.func_74782_a("Conversation", (NBTBase)optionTag);
        }
        this.writeStats(nbttagcompound, false);
        if (this.npcVariables != null) {
            nbttagcompound.func_74782_a("Variables", (NBTBase)this.npcVariables);
        }
        this.setTargetsMobs();
        nbttagcompound.func_74757_a("inventoryLocked", this.inventoryLocked);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.readShop(nbttagcompound, false);
        if (nbttagcompound.func_74764_b("Conversation")) {
            this.conversation = new DialogOption();
            this.conversation.readFromNBT((NBTTagCompound)nbttagcompound.func_74781_a("Conversation"));
        }
        this.updateStats(nbttagcompound);
        if (nbttagcompound.func_74764_b("Variables")) {
            this.npcVariables = (NBTTagCompound)nbttagcompound.func_74781_a("Variables");
        }
        if (this.timers != null) {
            NBTTagList list = new NBTTagList();
            for (TimeCounter counter : this.timers) {
            }
        }
        this.inventoryLocked = nbttagcompound.func_74767_n("inventoryLocked");
    }

    @Override
    public void writeEntityToSpawnerNBT(NBTTagCompound nbttagcompound, int spawnerX, int spawnerY, int spawnerZ) {
        super.writeEntityToSpawnerNBT(nbttagcompound, spawnerX, spawnerY, spawnerZ);
        this.writeShop(nbttagcompound, true);
    }

    @Override
    public void readEntityFromSpawnerNBT(NBTTagCompound nbttagcompound, int spawnerX, int spawnerY, int spawnerZ) {
        super.readEntityFromSpawnerNBT(nbttagcompound, spawnerX, spawnerY, spawnerZ);
        this.readShop(nbttagcompound, true);
    }

    public void writeShop(NBTTagCompound nbttagcompound, boolean addMappings) {
        if (this.trades != null) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.trades.length; ++i) {
                if (this.trades[i] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                if (addMappings) {
                    this.trades[i].writeToNBTWithMapping(tag);
                } else {
                    this.trades[i].writeToNBT(tag);
                }
                list.func_74742_a((NBTBase)tag);
            }
            nbttagcompound.func_74782_a("trades", (NBTBase)list);
        }
    }

    public void readShop(NBTTagCompound tag, boolean addMapings) {
        if (tag.func_74764_b("trades")) {
            NBTTagList list = (NBTTagList)tag.func_74781_a("trades");
            this.trades = new ShopRecipe[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ShopRecipe recipe;
                this.trades[i] = recipe = new ShopRecipe(list.func_150305_b(i), addMapings);
            }
        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.modelType);
        buffer.writeFloat(this.size);
        buffer.writeInt(this.color);
        buffer.writeBoolean(this.isMale);
        buffer.writeBoolean(this.hasPlayerTexture);
        buffer.writeInt(this.texture.length());
        for (int i = 0; i < this.texture.length(); ++i) {
            buffer.writeChar((int)this.texture.charAt(i));
        }
        PacketBase.writeString(buffer, this.displayName);
        PacketBase.writeString(buffer, this.entityTeam);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.modelType = additionalData.readInt();
        this.size = additionalData.readFloat();
        this.color = additionalData.readInt();
        this.isMale = additionalData.readBoolean();
        this.hasPlayerTexture = additionalData.readBoolean();
        int texLength = additionalData.readInt();
        this.texture = "";
        for (int i = 0; i < texLength; ++i) {
            this.texture = this.texture + additionalData.readChar();
        }
        this.displayName = PacketBase.readString(additionalData);
        this.entityTeam = PacketBase.readString(additionalData);
        this.resize();
    }

    public void resize() {
        float sizeBase = 1.8f;
        if (this.modelType == EnumRace.DWARF.ordinal()) {
            sizeBase = 1.4f;
        }
        this.field_70131_O = sizeBase * (0.5f + this.size);
        this.field_70130_N = 0.6f * (0.5f + this.size);
    }

    @Override
    public boolean isSuitableTargetAlly(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            if (this.entityTeam.equals("npc")) {
                return true;
            }
            if (this.entityTeam.startsWith("mob_")) {
                return false;
            }
            if (entity.func_96124_cp() != null && !this.isOnAlliedTeam(entity.func_96124_cp())) {
                return false;
            }
            String teamName = this.entityTeam.replace("npc_", "");
            return ReputationManager.instance.getPlayerReputation(entity.func_70005_c_(), teamName) >= this.repToAttack;
        }
        return super.isSuitableTargetAlly(entity);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (this.repOnDeath > 0 && damageSource.func_76364_f() instanceof EntityPlayer && !this.entityTeam.equals("npc") && !this.entityTeam.startsWith("mob")) {
            EntityPlayer player = (EntityPlayer)damageSource.func_76364_f();
            if (!player.field_71075_bZ.field_75098_d) {
                String team = this.entityTeam.replace("npc_", "");
                ReputationManager.instance.addReputation(player, team, -this.repOnDeath);
            }
        }
        super.func_70645_a(damageSource);
    }

    public boolean func_70104_M() {
        return !this.isInvincible;
    }

    @Override
    public float getSizeModifier() {
        return 1.0f;
    }

    @Override
    public boolean canTeleport() {
        return this.canTeleport;
    }

    @Override
    public int getInteligence() {
        return 2;
    }

    protected String func_70639_aQ() {
        return EnumVoice.getVoice((int)this.voice).say;
    }

    protected String func_70621_aR() {
        return EnumVoice.getVoice((int)this.voice).hurt;
    }

    protected String func_70673_aS() {
        return EnumVoice.getVoice((int)this.voice).death;
    }

    @Override
    public EnumCreatureAttribute func_70668_bt() {
        if (this.modelType == EnumRace.SKELETON.ordinal() || this.modelType == EnumRace.SPECTER.ordinal()) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return EnumCreatureAttribute.UNDEFINED;
    }

    public int getTimeCounter(String name) {
        if (this.timers == null) {
            return 0;
        }
        for (TimeCounter counter : this.timers) {
            if (!counter.name.equals(name)) continue;
            return counter.time;
        }
        return 0;
    }

    public void setTimeCounter(String name, int value) {
        if (this.timers == null) {
            this.timers = new ArrayList<TimeCounter>();
        }
        for (TimeCounter counter : this.timers) {
            if (!counter.name.equals(name)) continue;
            counter.time = value;
            return;
        }
        this.timers.add(new TimeCounter(name, value));
    }
}

