/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.mob;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.mob.registry.DungeonMonstersBase;
import com.chocolate.chocolateQuest.items.mobControl.ItemMobToSpawner;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityHumanMob
extends EntityHumanBase
implements IMob {
    DungeonMonstersBase monsterType;
    public boolean saveToSpawner = true;

    public EntityHumanMob(World world) {
        super(world);
        this.updateEntityAttributes();
        this.potionCount = this.field_70146_Z.nextInt(3);
        if (this.isBoss()) {
            this.shouldDespawn = false;
        }
    }

    public DungeonMonstersBase getMonsterType() {
        return null;
    }

    protected void updateEntityAttributes() {
        this.monsterType = this.getMonsterType();
        if (!this.isBoss()) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.monsterType.getAttack());
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.monsterType.getHealth());
            this.func_70606_j((float)this.monsterType.getHealth());
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.monsterType.getRange());
        }
        this.entityTeam = this.monsterType.getTeamName();
        this.shieldID = this.monsterType.getFlagId();
    }

    public boolean isBoss() {
        return false;
    }

    @Override
    public void readEntityFromSpawnerNBT(NBTTagCompound nbttagcompound, int spawnerX, int spawnerY, int spawnerZ) {
        super.readEntityFromSpawnerNBT(nbttagcompound, spawnerX, spawnerY, spawnerZ);
        this.func_110171_b(spawnerX, spawnerY, spawnerZ, 30);
        ItemStack rightHandItem = this.func_71124_b(0);
        if (rightHandItem != null && rightHandItem.func_77973_b() == ChocolateQuest.banner) {
            rightHandItem.func_77964_b(this.getTeamID());
        }
        if (this.leftHandItem != null && this.leftHandItem.func_77973_b() == ChocolateQuest.shield) {
            this.leftHandItem.func_77964_b(this.getTeamID());
        }
    }

    @Override
    protected boolean func_70085_c(EntityPlayer player) {
        if (this.func_142014_c((EntityLivingBase)player)) {
            return super.func_70085_c(player);
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        EntityPlayer p;
        if (!this.field_70170_p.field_72995_K && this.party != null && this.party.getLeader().equals(this) && !this.shouldDespawn && this.saveToSpawner && (p = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)ChocolateQuest.config.distToDespawn)) == null) {
            int z;
            int y;
            int x;
            if (this.func_110175_bO()) {
                ChunkCoordinates coord = this.func_110172_bL();
                x = coord.field_71574_a;
                y = coord.field_71572_b;
                z = coord.field_71573_c;
            } else {
                x = MathHelper.func_76128_c((double)this.field_70165_t);
                y = MathHelper.func_76128_c((double)this.field_70163_u);
                z = MathHelper.func_76128_c((double)this.field_70161_v);
            }
            if (ItemMobToSpawner.saveToSpawner(x, y, z, this)) {
                if (this.party != null) {
                    for (int i = 0; i < this.party.getMembersLength(); ++i) {
                        EntityHumanBase e = this.party.getMember(i);
                        if (e == null) continue;
                        if (((Entity)e).field_70154_o != null) {
                            ((Entity)e).field_70154_o.func_70106_y();
                        }
                        e.func_70106_y();
                    }
                }
                if (this.field_70154_o != null) {
                    this.field_70154_o.func_70106_y();
                }
                this.func_70106_y();
            }
        }
        super.func_70636_d();
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this.party == null) {
            double targetDistance = 10.0;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(targetDistance, 1.2, targetDistance));
            for (Entity entity : list) {
                EntityHumanBase human;
                if (!(entity instanceof EntityHumanBase) || !this.func_142014_c((EntityLivingBase)(human = (EntityHumanBase)entity))) continue;
                if (human.party == null) {
                    human.tryPutIntoPArty(human);
                }
                if (!human.party.tryToAddNewMember(this, false)) continue;
                return;
            }
        }
    }

    @Override
    public boolean canSprint() {
        return this.field_70170_p.field_73013_u.func_151525_a() >= EnumDifficulty.HARD.func_151525_a();
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        float healthValue = this.func_110138_aP() / 4.0f;
        float armorValue = 0.0f;
        for (int i = 0; i < 4; ++i) {
            if (this.func_71124_b(1) == null) continue;
            armorValue += (float)((ItemArmor)this.func_71124_b(1).func_77973_b()).func_82812_d().func_78044_b(2);
        }
        this.field_70728_aV = (int)(healthValue + (armorValue /= 3.0f));
        if (this.isCaptain()) {
            ++this.field_70728_aV;
        }
        super.func_70645_a(damageSource);
    }

    protected void func_70628_a(boolean par1, int looting) {
        block6: {
            int k;
            int j;
            block5: {
                super.func_70628_a(par1, looting);
                j = this.field_70146_Z.nextInt(3);
                if (looting > 0) {
                    j += this.field_70146_Z.nextInt(looting + 1);
                }
                if (this.field_70146_Z.nextInt(3) == 0) {
                    for (k = 0; k < j; ++k) {
                        this.func_70099_a(new ItemStack(Items.field_151166_bC), 0.0f);
                    }
                }
                if (this.field_70146_Z.nextInt(3) != 0) break block5;
                for (k = 0; k < j; ++k) {
                    this.func_70099_a(new ItemStack(Items.field_151074_bl), 0.0f);
                }
                break block6;
            }
            if (this.field_70146_Z.nextInt(4) != 0) break block6;
            for (k = 0; k < j; ++k) {
                this.func_70099_a(new ItemStack(Items.field_151100_aR, 1, 4), 0.0f);
            }
        }
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.field_73013_u.func_151525_a() > EnumDifficulty.PEACEFUL.func_151525_a();
    }
}

