/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.handHelper;

import com.chocolate.chocolateQuest.API.IRangedWeapon;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.handHelper.HandHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class HandRanged
extends HandHelper {
    boolean aiming = false;
    boolean isMeleWeapon;
    protected float range;
    protected int aimDelay;
    protected int aimingTime;
    protected int aimDelayTime;
    IRangedWeapon rangedWeapon;

    public HandRanged(EntityHumanBase owner, ItemStack itemStack) {
        super(owner, itemStack);
        if (this.currentItem.func_77973_b() instanceof IRangedWeapon) {
            this.rangedWeapon = (IRangedWeapon)this.currentItem.func_77973_b();
            this.range = this.rangedWeapon.getRange((EntityLivingBase)owner, itemStack);
            this.aimDelay = this.rangedWeapon.getCooldown((EntityLivingBase)owner, itemStack);
            this.isMeleWeapon = this.rangedWeapon.isMeleeWeapon((EntityLivingBase)owner, itemStack);
        } else {
            this.range = 4096.0f;
            this.aimDelay = 10;
            this.isMeleWeapon = false;
        }
    }

    @Override
    public boolean attackWithRange(Entity target, float f) {
        if ((double)f < this.getRange()) {
            int aimTime;
            if (this.isAiming()) {
                if (this.aimingTime <= 0) {
                    this.doRangeAttack(target, f);
                    this.owner.setAiming(this, false);
                    this.aimDelayTime = this.aimDelay;
                }
            } else if (this.aimDelayTime <= 0 && (aimTime = this.getAimTime(target)) >= 0) {
                this.owner.setAiming(this, true);
                this.aimingTime = aimTime;
            }
            return true;
        }
        return false;
    }

    public int getAimTime(Entity target) {
        if (this.rangedWeapon != null) {
            return this.rangedWeapon.startAiming(this.currentItem, (EntityLivingBase)this.owner, target);
        }
        return this.owner.getAttackSpeed();
    }

    public void doRangeAttack(Entity target, float f) {
        if (this.currentItem.func_77973_b() instanceof IRangedWeapon) {
            ((IRangedWeapon)this.currentItem.func_77973_b()).shootFromEntity((EntityLivingBase)this.owner, this.currentItem, this.owner.getHandAngle(this), target);
        } else {
            EntityArrow arrow = new EntityArrow(this.owner.field_70170_p, (EntityLivingBase)this.owner, 0.0f);
            arrow.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u + (double)this.owner.func_70047_e(), this.owner.field_70161_v);
            if (!this.owner.field_70170_p.field_72995_K) {
                float dist;
                if (target.field_70163_u < this.owner.field_70163_u) {
                    arrow.func_70243_d(true);
                }
                float distFactor = f / 10.0f;
                double arrowMotionX = target.field_70165_t - this.owner.field_70165_t + target.field_70159_w * (double)distFactor;
                double arrowMotionZ = target.field_70161_v - this.owner.field_70161_v + target.field_70179_y * (double)distFactor;
                double d2 = target.field_70163_u + (double)target.func_70047_e() - (double)0.7f - arrow.field_70163_u;
                float hFact = dist = MathHelper.func_76129_c((float)f);
                if (dist < 16.0f) {
                    hFact *= 0.38f;
                }
                this.owner.field_70170_p.func_72956_a((Entity)this.owner, "random.bow", 1.0f, 1.0f / (this.owner.func_70681_au().nextFloat() * 0.4f + 0.8f));
                float damage = (float)this.owner.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2.0f;
                arrow.func_70186_c(arrowMotionX, d2 + (double)hFact, arrowMotionZ, 1.0f, this.owner.accuracy);
                arrow.func_70239_b((double)damage);
                arrow.field_70159_w *= (double)Math.max(1.0f, hFact / 18.0f);
                arrow.field_70179_y *= (double)Math.max(1.0f, hFact / 18.0f);
                this.owner.field_70170_p.func_72838_d((Entity)arrow);
            }
        }
    }

    @Override
    public void onUpdate() {
        if (this.isAiming() && this.rangedWeapon != null && this.rangedWeapon.shouldUpdate((EntityLivingBase)this.owner)) {
            this.currentItem.func_77973_b().func_77663_a(this.currentItem, this.owner.field_70170_p, (Entity)this.owner, this.owner.getHandAngle(this), false);
        }
        if (this.aimDelayTime > 0) {
            --this.aimDelayTime;
        }
        if (this.aimingTime >= -10) {
            --this.aimingTime;
        } else if (this.isAiming() && !this.owner.field_70170_p.field_72995_K) {
            this.owner.setAiming(this, false);
        }
        super.onUpdate();
    }

    @Override
    public void setAiming(boolean aim) {
        this.aiming = aim;
        this.aimingTime = 0;
    }

    @Override
    public boolean isAiming() {
        return this.aiming;
    }

    @Override
    public boolean isRanged() {
        return true;
    }

    @Override
    public double getDistanceToStopAdvancing() {
        return this.isMeleWeapon ? super.getDistanceToStopAdvancing() : this.getRange();
    }

    @Override
    public double getMaxRangeForAttack() {
        return this.getRange();
    }

    public double getRange() {
        if (this.rangedWeapon != null) {
            return this.rangedWeapon.getRange((EntityLivingBase)this.owner, this.currentItem);
        }
        return this.range;
    }
}

