/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.ai.AIBossAttack;
import com.chocolate.chocolateQuest.entity.boss.AttackKickQuadruped;
import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.packets.PacketEntityAnimation;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBull
extends EntityBaseBoss {
    public int smashTime;
    public final int smashSpeed = 30;
    final byte CHARGE_ANIM = (byte)5;
    final byte SMASH = (byte)6;
    public boolean charge;
    public int chargeTime = 0;
    public int chargeTimeMax = 50;
    private float damageRight;
    private float damageLeft;
    public AttackKickQuadruped kickHelper = new AttackKickQuadruped(this);

    public EntityBull(World par1World) {
        super(par1World);
        this.field_70728_aV = 5;
        this.size = this.field_70146_Z.nextFloat() * 4.0f + 1.0f;
        this.field_70138_W = 2.0f;
        this.resize();
        this.kickHelper.setSpeed(16 + (int)(this.size * 5.0f));
        this.limitRotation = true;
    }

    @Override
    protected void scaleAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3 + 0.01 * (double)this.lvl);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(14.0 + 0.8 * (double)this.lvl);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0 + 200.0 * (double)this.lvl);
    }

    @Override
    public void addAITasks() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIBossAttack(this, 1.0f, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    @Override
    public float getMinSize() {
        return 0.6f;
    }

    @Override
    public float getSizeVariation() {
        return 0.4f;
    }

    @Override
    public void animationBoss(byte animType) {
        switch (animType) {
            case 5: {
                this.startCharging();
                return;
            }
            case 6: {
                this.startSmashing();
                return;
            }
        }
        this.kickHelper.kick(animType);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70128_L) {
            this.updateCharge();
            this.updateSmash();
            this.kickHelper.onUpdate();
        }
    }

    @Override
    public boolean attackInProgress() {
        return this.kickHelper.isAttackInProgress() || this.smashTime > 0;
    }

    @Override
    public boolean shouldMoveToEntity(double d1, Entity target) {
        if (this.attackInProgress() || this.charge) {
            return false;
        }
        return super.shouldMoveToEntity(d1, target);
    }

    @Override
    public void func_70785_a(Entity entity, float f) {
        int angle;
        boolean targetUp;
        float width = this.field_70130_N + entity.field_70130_N;
        boolean bl = targetUp = this.field_70163_u - entity.field_70163_u + (double)this.field_70131_O <= 0.0 && f < this.size * this.size * 2.0f;
        if (!this.isAttacking() && (f > (this.field_70130_N + 8.0f) * (this.field_70130_N + 8.0f) || targetUp) && ((angle = (int)MathHelper.func_76138_g((double)(BDHelper.getAngleBetweenEntities((Entity)this, entity) - (double)this.field_70177_z))) < 1 && angle > -1 || targetUp)) {
            this.startCharging();
        }
        if (this.field_70173_aa % 30 == 0 && !this.field_70170_p.field_72995_K && !this.charge && this.smashTime == 0 && f < (width + 2.0f) * (width + 2.0f)) {
            if (this.field_70146_Z.nextInt(4) == 0 && this.kickHelper.kickTime == 0) {
                this.startSmashing();
            } else {
                this.kickHelper.attackTarget(entity);
            }
        }
        super.func_70785_a(entity, f);
    }

    public void updateSmash() {
        if (this.smashTime > 0) {
            --this.smashTime;
            if (this.smashTime == 1) {
                float rotation = this.field_70759_as * 3.141592f / 180.0f;
                double d = this.size;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(d, 0.0, d).func_72321_a(0.0, -2.0, 0.0));
                int min = -60;
                int max = 60;
                for (int j = 0; j < list.size(); ++j) {
                    int angle;
                    Entity entity1 = (Entity)list.get(j);
                    if (!(entity1 instanceof EntityLivingBase) || !entity1.func_70067_L() || this.func_70028_i(entity1) || entity1 == this.field_70153_n || (angle = (int)MathHelper.func_76138_g((double)(BDHelper.getAngleBetweenEntities((Entity)this, entity1) - (double)this.field_70177_z))) < min || angle > max || !this.func_70652_k(entity1)) continue;
                    float dist = 1.0f;
                    double x = -Math.sin(rotation) * (double)dist;
                    double z = Math.cos(rotation) * (double)dist;
                    entity1.field_70159_w += x;
                    entity1.field_70179_y += z;
                }
                if (!this.field_70170_p.field_72995_K) {
                    EntityBaseBall ball = new EntityBaseBall(this.field_70170_p, (EntityLivingBase)this, 4, 2);
                    float legAngle = 0.5f;
                    double x = this.field_70165_t - (double)(MathHelper.func_76126_a((float)(rotation + 0.5f)) * this.field_70130_N);
                    double z = this.field_70161_v + (double)(MathHelper.func_76134_b((float)(rotation + 0.5f)) * this.field_70130_N);
                    ball.field_70165_t = x;
                    ball.field_70163_u = this.field_70163_u + 1.0;
                    ball.field_70161_v = z;
                    this.field_70170_p.func_72838_d((Entity)ball);
                    ball = new EntityBaseBall(this.field_70170_p, (EntityLivingBase)this, 4, 2);
                    x = this.field_70165_t - (double)(MathHelper.func_76126_a((float)(rotation - 0.5f)) * this.field_70130_N);
                    z = this.field_70161_v + (double)(MathHelper.func_76134_b((float)(rotation - 0.5f)) * this.field_70130_N);
                    ball.field_70165_t = x;
                    ball.field_70161_v = z;
                    this.field_70170_p.func_72838_d((Entity)ball);
                }
            }
        }
    }

    public void startSmashing() {
        if (!this.field_70170_p.field_72995_K) {
            PacketEntityAnimation packet = new PacketEntityAnimation(this.func_145782_y(), 6);
            ChocolateQuest.channel.sendToAllAround((Entity)this, packet, 64);
        }
        if (this.smashTime == 0) {
            this.smashTime = 30;
        }
    }

    public void updateCharge() {
        if (this.charge) {
            ++this.chargeTime;
            float speed = Math.min(0.5f, 0.1f + (float)this.chargeTime / (float)this.chargeTimeMax);
            float rotation = this.field_70177_z * 3.141592f / 180.0f;
            double dx = -MathHelper.func_76126_a((float)rotation) * speed;
            double dz = MathHelper.func_76134_b((float)rotation) * speed;
            this.field_70159_w = dx;
            this.field_70179_y = dz;
            if (this.chargeTime >= this.chargeTimeMax) {
                this.chargeTime = 0;
                this.charge = false;
            }
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.2, 0.2));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || this.func_70028_i(entity1) || entity1 == this.field_70153_n || !this.func_70652_k(entity1)) continue;
                float dist = 1.0f;
                double x = -Math.sin(rotation) * (double)dist;
                double z = Math.cos(rotation) * (double)dist;
                entity1.field_70159_w += x;
                entity1.field_70179_y += z;
            }
        }
    }

    public void startCharging() {
        if (!this.field_70170_p.field_72995_K) {
            PacketEntityAnimation packet = new PacketEntityAnimation(this.func_145782_y(), 5);
            ChocolateQuest.channel.sendToAllAround((Entity)this, packet, 64);
        }
        if (this.chargeTime == 0) {
            this.charge = true;
        }
    }

    @Override
    protected boolean func_70650_aV() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean flag = super.func_70097_a(par1DamageSource, par2);
        if (!par1DamageSource.func_76352_a() && par1DamageSource.func_76346_g() != null && flag) {
            int angle;
            Entity attacker = par1DamageSource.func_76346_g();
            double dist = this.func_70068_e(attacker);
            if (!this.field_70170_p.field_72995_K && this.smashTime <= 0 && !this.charge && dist < (double)(this.field_70130_N * this.field_70130_N * 2.0f * 2.0f)) {
                this.kickHelper.attackTarget(attacker);
            }
            if ((angle = (int)MathHelper.func_76138_g((double)(BDHelper.getAngleBetweenEntities((Entity)this, attacker) - (double)this.field_70177_z))) > 45 && angle < 135) {
                this.damageRight += par2;
                if (this.damageRight > this.func_110138_aP() / 4.0f) {
                    this.setHurtRight(true);
                }
            }
            if (angle < -45 && angle > -135) {
                this.damageLeft += par2;
                if (this.damageLeft > this.func_110138_aP() / 4.0f) {
                    this.setHurtLeft(true);
                }
            }
        }
        return flag;
    }

    @Override
    protected void resize() {
        this.func_70105_a(this.size, this.size * 1.4f);
    }

    public boolean isHurtLeft() {
        return this.getAnimFlag(1);
    }

    public void setHurtLeft(boolean attacking) {
        this.setAnimFlag(1, attacking);
    }

    public boolean isHurtRight() {
        return this.getAnimFlag(2);
    }

    public void setHurtRight(boolean attacking) {
        this.setAnimFlag(2, attacking);
    }

    protected String func_70639_aQ() {
        return "chocolatequest:bull_speak";
    }

    protected String func_70621_aR() {
        return "chocolatequest:bull_hurt";
    }

    protected String func_70673_aS() {
        return "chocolatequest:bull_death";
    }

    @Override
    protected int getDropMaterial() {
        return 2;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        int ammount = 2 + (int)(this.getMonsterDificulty() * this.getMonsterDificulty()) / 2;
        if (this.isHurtRight()) {
            ammount = (int)((float)ammount + (1.0f + this.getMonsterDificulty() / 2.0f));
        }
        if (this.isHurtLeft()) {
            ammount = (int)((float)ammount + (1.0f + this.getMonsterDificulty() / 2.0f));
        }
        this.func_70099_a(new ItemStack(ChocolateQuest.material, ammount, this.getDropMaterial()), 0.2f);
    }
}

